/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import org.apache.hudi.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.LruCachedBlock;

@InterfaceAudience.Private
public class LruCachedBlockQueue
implements HeapSize {
    private MinMaxPriorityQueue<LruCachedBlock> queue;
    private long heapSize;
    private long maxSize;

    public LruCachedBlockQueue(long maxSize, long blockSize) {
        int initialSize = (int)(maxSize / blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = MinMaxPriorityQueue.expectedSize(initialSize).create();
        this.heapSize = 0L;
        this.maxSize = maxSize;
    }

    public void add(LruCachedBlock cb) {
        if (this.heapSize < this.maxSize) {
            this.queue.add(cb);
            this.heapSize += cb.heapSize();
        } else {
            LruCachedBlock head = this.queue.peek();
            if (cb.compareTo(head) > 0) {
                this.heapSize += cb.heapSize();
                this.heapSize -= head.heapSize();
                if (this.heapSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.heapSize += head.heapSize();
                }
                this.queue.add(cb);
            }
        }
    }

    public LruCachedBlock poll() {
        return this.queue.poll();
    }

    public LruCachedBlock pollLast() {
        return this.queue.pollLast();
    }

    @Override
    public long heapSize() {
        return this.heapSize;
    }
}

