/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.Server;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.hudi.org.apache.hadoop.hbase.util.Triple;

@InterfaceAudience.Private
public class CatalogJanitor
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog((String)CatalogJanitor.class.getName());
    private final Server server;
    private final MasterServices services;
    private AtomicBoolean enabled = new AtomicBoolean(true);
    private AtomicBoolean alreadyRunning = new AtomicBoolean(false);
    private final Connection connection;

    CatalogJanitor(Server server, MasterServices services) {
        super("CatalogJanitor-" + server.getServerName().toShortString(), server, server.getConfiguration().getInt("hbase.catalogjanitor.interval", 300000));
        this.server = server;
        this.services = services;
        this.connection = server.getConnection();
    }

    @Override
    protected boolean initialChore() {
        try {
            if (this.enabled.get()) {
                this.scan();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed initial scan of catalog table", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean setEnabled(boolean enabled) {
        boolean alreadyEnabled = this.enabled.getAndSet(enabled);
        if (!enabled && alreadyEnabled) {
            while (this.alreadyRunning.get()) {
                Threads.sleepWithoutInterrupt(100L);
            }
        }
        return alreadyEnabled;
    }

    boolean getEnabled() {
        return this.enabled.get();
    }

    @Override
    protected void chore() {
        try {
            AssignmentManager am = this.services.getAssignmentManager();
            if (this.enabled.get() && am != null && am.isFailoverCleanupDone() && am.getRegionStates().getRegionsInTransition().size() == 0) {
                this.scan();
            } else {
                LOG.warn((Object)"CatalogJanitor disabled! Not running scan.");
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed scan of catalog table", (Throwable)e);
        }
    }

    Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>> getMergedRegionsAndSplitParents() throws IOException {
        return this.getMergedRegionsAndSplitParents(null);
    }

    Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>> getMergedRegionsAndSplitParents(final TableName tableName) throws IOException {
        final boolean isTableSpecified = tableName != null;
        final AtomicInteger count = new AtomicInteger(0);
        final TreeMap splitParents = new TreeMap(new SplitParentFirstComparator());
        final TreeMap mergedRegions = new TreeMap();
        MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

            @Override
            public boolean processRow(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                count.incrementAndGet();
                HRegionInfo info = HRegionInfo.getHRegionInfo(r);
                if (info == null) {
                    return true;
                }
                if (isTableSpecified && info.getTable().compareTo(tableName) > 0) {
                    return false;
                }
                if (info.isSplitParent()) {
                    splitParents.put(info, r);
                }
                if (r.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null) {
                    mergedRegions.put(info, r);
                }
                return true;
            }
        };
        MetaScanner.metaScan(this.connection, visitor, tableName);
        return new Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>>(count.get(), mergedRegions, splitParents);
    }

    boolean cleanMergeRegion(HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB) throws IOException {
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir(rootdir, mergedRegion.getTable());
        HTableDescriptor htd = this.getTableDescriptor(mergedRegion.getTable());
        HRegionFileSystem regionFs = null;
        try {
            regionFs = HRegionFileSystem.openRegionFromFileSystem(this.services.getConfiguration(), fs, tabledir, mergedRegion, true);
        }
        catch (IOException e) {
            LOG.warn((Object)("Merged region does not exist: " + mergedRegion.getEncodedName()));
        }
        if (regionFs == null || !regionFs.hasReferences(htd)) {
            LOG.debug((Object)("Deleting region " + regionA.getRegionNameAsString() + " and " + regionB.getRegionNameAsString() + " from fs because merged region no longer holds references"));
            HFileArchiver.archiveRegion(this.services.getConfiguration(), fs, regionA);
            HFileArchiver.archiveRegion(this.services.getConfiguration(), fs, regionB);
            MetaTableAccessor.deleteMergeQualifiers(this.server.getConnection(), mergedRegion);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int scan() throws IOException {
        try {
            if (!this.alreadyRunning.compareAndSet(false, true)) {
                int n = 0;
                return n;
            }
            Triple<Integer, Map<HRegionInfo, Result>, Map<HRegionInfo, Result>> scanTriple = this.getMergedRegionsAndSplitParents();
            int count = scanTriple.getFirst();
            int mergeCleaned = 0;
            Map<HRegionInfo, Result> mergedRegions = scanTriple.getSecond();
            for (Map.Entry<HRegionInfo, Result> e : mergedRegions.entrySet()) {
                HRegionInfo regionA = HRegionInfo.getHRegionInfo(e.getValue(), HConstants.MERGEA_QUALIFIER);
                HRegionInfo regionB = HRegionInfo.getHRegionInfo(e.getValue(), HConstants.MERGEB_QUALIFIER);
                if (regionA == null || regionB == null) {
                    LOG.warn((Object)("Unexpected references regionA=" + (regionA == null ? "null" : regionA.getRegionNameAsString()) + ",regionB=" + (regionB == null ? "null" : regionB.getRegionNameAsString()) + " in merged region " + e.getKey().getRegionNameAsString()));
                    continue;
                }
                if (!this.cleanMergeRegion(e.getKey(), regionA, regionB)) continue;
                ++mergeCleaned;
            }
            Map<HRegionInfo, Result> splitParents = scanTriple.getThird();
            int splitCleaned = 0;
            HashSet<String> parentNotCleaned = new HashSet<String>();
            for (Map.Entry<HRegionInfo, Result> e : splitParents.entrySet()) {
                if (!parentNotCleaned.contains(e.getKey().getEncodedName()) && this.cleanParent(e.getKey(), e.getValue())) {
                    ++splitCleaned;
                    continue;
                }
                PairOfSameType<HRegionInfo> daughters = HRegionInfo.getDaughterRegions(e.getValue());
                parentNotCleaned.add(daughters.getFirst().getEncodedName());
                parentNotCleaned.add(daughters.getSecond().getEncodedName());
            }
            if (mergeCleaned + splitCleaned != 0) {
                LOG.info((Object)("Scanned " + count + " catalog row(s), gc'd " + mergeCleaned + " unreferenced merged region(s) and " + splitCleaned + " unreferenced parent region(s)"));
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Scanned " + count + " catalog row(s), gc'd " + mergeCleaned + " unreferenced merged region(s) and " + splitCleaned + " unreferenced parent region(s)"));
            }
            int n = mergeCleaned + splitCleaned;
            return n;
        }
        finally {
            this.alreadyRunning.set(false);
        }
    }

    boolean cleanParent(HRegionInfo parent, Result rowContent) throws IOException {
        boolean result = false;
        if (rowContent.getValue(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER) != null) {
            return result;
        }
        PairOfSameType<HRegionInfo> daughters = HRegionInfo.getDaughterRegions(rowContent);
        Pair<Boolean, Boolean> a = this.checkDaughterInFs(parent, daughters.getFirst());
        Pair<Boolean, Boolean> b = this.checkDaughterInFs(parent, daughters.getSecond());
        if (this.hasNoReferences(a) && this.hasNoReferences(b)) {
            LOG.debug((Object)("Deleting region " + parent.getRegionNameAsString() + " because daughter splits no longer hold references"));
            FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Archiving parent region: " + parent));
            }
            HFileArchiver.archiveRegion(this.services.getConfiguration(), fs, parent);
            MetaTableAccessor.deleteRegion(this.connection, parent);
            result = true;
        }
        return result;
    }

    private boolean hasNoReferences(Pair<Boolean, Boolean> p) {
        return p.getFirst() == false || p.getSecond() == false;
    }

    Pair<Boolean, Boolean> checkDaughterInFs(HRegionInfo parent, HRegionInfo daughter) throws IOException {
        HColumnDescriptor family;
        if (daughter == null) {
            return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
        }
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        Path rootdir = this.services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir(rootdir, daughter.getTable());
        Path daughterRegionDir = new Path(tabledir, daughter.getEncodedName());
        HRegionFileSystem regionFs = null;
        try {
            if (!FSUtils.isExists(fs, daughterRegionDir)) {
                return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Error trying to determine if daughter region exists, assuming exists and has references", (Throwable)ioe);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        try {
            regionFs = HRegionFileSystem.openRegionFromFileSystem(this.services.getConfiguration(), fs, tabledir, daughter, true);
        }
        catch (IOException e) {
            LOG.warn((Object)("Error trying to determine referenced files from : " + daughter.getEncodedName() + ", to: " + parent.getEncodedName() + " assuming has references"), (Throwable)e);
            return new Pair<Boolean, Boolean>(Boolean.TRUE, Boolean.TRUE);
        }
        boolean references = false;
        HTableDescriptor parentDescriptor = this.getTableDescriptor(parent.getTable());
        Iterator<HColumnDescriptor> i$ = parentDescriptor.getFamilies().iterator();
        while (i$.hasNext() && !(references = regionFs.hasReferences((family = i$.next()).getNameAsString()))) {
        }
        return new Pair<Boolean, Boolean>(Boolean.TRUE, references);
    }

    private HTableDescriptor getTableDescriptor(TableName tableName) throws FileNotFoundException, IOException {
        return this.services.getTableDescriptors().get(tableName);
    }

    public boolean cleanMergeQualifier(HRegionInfo region) throws IOException {
        Pair<HRegionInfo, HRegionInfo> mergeRegions = MetaTableAccessor.getRegionsFromMergeQualifier(this.services.getConnection(), region.getRegionName());
        if (mergeRegions == null || mergeRegions.getFirst() == null && mergeRegions.getSecond() == null) {
            return true;
        }
        if (mergeRegions.getFirst() == null || mergeRegions.getSecond() == null) {
            LOG.error((Object)("Merged region " + region.getRegionNameAsString() + " has only one merge qualifier in META."));
            return false;
        }
        return this.cleanMergeRegion(region, mergeRegions.getFirst(), mergeRegions.getSecond());
    }

    static class SplitParentFirstComparator
    implements Comparator<HRegionInfo> {
        Comparator<byte[]> rowEndKeyComparator = new Bytes.RowEndKeyComparator();

        SplitParentFirstComparator() {
        }

        @Override
        public int compare(HRegionInfo left, HRegionInfo right) {
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int result = left.getTable().compareTo(right.getTable());
            if (result != 0) {
                return result;
            }
            result = Bytes.compareTo(left.getStartKey(), right.getStartKey());
            if (result != 0) {
                return result;
            }
            result = this.rowEndKeyComparator.compare(right.getEndKey(), left.getEndKey());
            return result;
        }
    }
}

