/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.ModifyRegionUtils;

@InterfaceAudience.Private
public class TruncateTableProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.TruncateTableState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(TruncateTableProcedure.class);
    private boolean preserveSplits;
    private List<HRegionInfo> regions;
    private UserGroupInformation user;
    private HTableDescriptor hTableDescriptor;
    private TableName tableName;

    public TruncateTableProcedure() {
    }

    public TruncateTableProcedure(MasterProcedureEnv env, TableName tableName, boolean preserveSplits) throws IOException {
        this.tableName = tableName;
        this.preserveSplits = preserveSplits;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case TRUNCATE_TABLE_PRE_OPERATION: {
                    if (!this.prepareTruncate(env)) {
                        assert (this.isFailed()) : "the truncate should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    LOG.debug((Object)("waiting for '" + this.getTableName() + "' regions in transition"));
                    this.regions = ProcedureSyncWait.getRegionsFromMeta(env, this.getTableName());
                    assert (this.regions != null && !this.regions.isEmpty()) : "unexpected 0 regions";
                    ProcedureSyncWait.waitRegionInTransition(env, this.regions);
                    this.preTruncate(env);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_REMOVE_FROM_META);
                    break;
                }
                case TRUNCATE_TABLE_REMOVE_FROM_META: {
                    this.hTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
                    DeleteTableProcedure.deleteFromMeta(env, this.getTableName(), this.regions);
                    DeleteTableProcedure.deleteAssignmentState(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CLEAR_FS_LAYOUT);
                    break;
                }
                case TRUNCATE_TABLE_CLEAR_FS_LAYOUT: {
                    DeleteTableProcedure.deleteFromFs(env, this.getTableName(), this.regions, true);
                    if (!this.preserveSplits) {
                        this.regions = Arrays.asList(ModifyRegionUtils.createHRegionInfos(this.hTableDescriptor, null));
                    }
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_CREATE_FS_LAYOUT);
                    break;
                }
                case TRUNCATE_TABLE_CREATE_FS_LAYOUT: {
                    this.regions = CreateTableProcedure.createFsLayout(env, this.hTableDescriptor, this.regions);
                    CreateTableProcedure.updateTableDescCache(env, this.getTableName());
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ADD_TO_META);
                    break;
                }
                case TRUNCATE_TABLE_ADD_TO_META: {
                    this.regions = CreateTableProcedure.addTableToMeta(env, this.hTableDescriptor, this.regions);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ASSIGN_REGIONS);
                    break;
                }
                case TRUNCATE_TABLE_ASSIGN_REGIONS: {
                    CreateTableProcedure.assignRegions(env, this.getTableName(), this.regions);
                    this.setNextState(MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_POST_OPERATION);
                    this.hTableDescriptor = null;
                    this.regions = null;
                    break;
                }
                case TRUNCATE_TABLE_POST_OPERATION: {
                    this.postTruncate(env);
                    LOG.debug((Object)("truncate '" + this.getTableName() + "' completed"));
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | HBaseException e) {
            LOG.warn((Object)("Retriable error trying to truncate table=" + this.getTableName() + " state=" + state), (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.TruncateTableState state) {
        if (state == MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_PRE_OPERATION) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected MasterProcedureProtos.TruncateTableState getState(int stateId) {
        return MasterProcedureProtos.TruncateTableState.valueOf(stateId);
    }

    protected int getStateId(MasterProcedureProtos.TruncateTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.TruncateTableState getInitialState() {
        return MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_PRE_OPERATION;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    public boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized((Procedure)this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableExclusiveLock((Procedure)this, this.getTableName());
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableExclusiveLock((Procedure)this, this.getTableName());
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.getTableName());
        sb.append(" preserveSplits=");
        sb.append(this.preserveSplits);
        sb.append(")");
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.TruncateTableStateData.Builder state = MasterProcedureProtos.TruncateTableStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setPreserveSplits(this.preserveSplits);
        if (this.hTableDescriptor != null) {
            state.setTableSchema(this.hTableDescriptor.convert());
        } else {
            state.setTableName(ProtobufUtil.toProtoTableName(this.tableName));
        }
        if (this.regions != null) {
            for (HRegionInfo hri : this.regions) {
                state.addRegionInfo(HRegionInfo.convert(hri));
            }
        }
        state.build().writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.TruncateTableStateData state = MasterProcedureProtos.TruncateTableStateData.parseDelimitedFrom(stream);
        this.user = MasterProcedureUtil.toUserInfo(state.getUserInfo());
        if (state.hasTableSchema()) {
            this.hTableDescriptor = HTableDescriptor.convert(state.getTableSchema());
            this.tableName = this.hTableDescriptor.getTableName();
        } else {
            this.tableName = ProtobufUtil.toTableName(state.getTableName());
        }
        this.preserveSplits = state.getPreserveSplits();
        if (state.getRegionInfoCount() == 0) {
            this.regions = null;
        } else {
            this.regions = new ArrayList<HRegionInfo>(state.getRegionInfoCount());
            for (HBaseProtos.RegionInfo hri : state.getRegionInfoList()) {
                this.regions.add(HRegionInfo.convert(hri));
            }
        }
    }

    private boolean prepareTruncate(MasterProcedureEnv env) throws IOException {
        try {
            env.getMasterServices().checkTableModifiable(this.getTableName());
        }
        catch (TableNotDisabledException | TableNotFoundException e) {
            this.setFailure("master-truncate-table", e);
            return false;
        }
        return true;
    }

    private boolean preTruncate(MasterProcedureEnv env) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            final TableName tableName = this.getTableName();
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    cpHost.preTruncateTableHandler(tableName);
                    return null;
                }
            });
        }
        return true;
    }

    private void postTruncate(MasterProcedureEnv env) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            final TableName tableName = this.getTableName();
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    cpHost.postTruncateTableHandler(tableName);
                    return null;
                }
            });
        }
    }
}

