/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.ProcedureManagerHost;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.RegionServerProcedureManager;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.flush.RegionServerFlushTableProcedureManager;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.zookeeper.KeeperException;

public class RegionServerProcedureManagerHost
extends ProcedureManagerHost<RegionServerProcedureManager> {
    private static final Log LOG = LogFactory.getLog(RegionServerProcedureManagerHost.class);

    public void initialize(RegionServerServices rss) throws KeeperException {
        for (RegionServerProcedureManager proc : this.procedures) {
            LOG.debug((Object)("Procedure " + proc.getProcedureSignature() + " is initializing"));
            proc.initialize(rss);
            LOG.debug((Object)("Procedure " + proc.getProcedureSignature() + " is initialized"));
        }
    }

    public void start() {
        for (RegionServerProcedureManager proc : this.procedures) {
            LOG.debug((Object)("Procedure " + proc.getProcedureSignature() + " is starting"));
            proc.start();
            LOG.debug((Object)("Procedure " + proc.getProcedureSignature() + " is started"));
        }
    }

    public void stop(boolean force) {
        for (RegionServerProcedureManager proc : this.procedures) {
            try {
                proc.stop(force);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to close procedure " + proc.getProcedureSignature() + " cleanly"), (Throwable)e);
            }
        }
    }

    @Override
    public void loadProcedures(Configuration conf) {
        this.loadUserProcedures(conf, "hbase.procedure.regionserver.classes");
        this.procedures.add(new RegionServerSnapshotManager());
        this.procedures.add(new RegionServerFlushTableProcedureManager());
    }
}

