/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.ThrottlingException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface OperationQuota {
    public void checkQuota(int var1, int var2, int var3) throws ThrottlingException;

    public void close();

    public void addGetResult(Result var1);

    public void addScanResult(List<Result> var1);

    public void addMutation(Mutation var1);

    public long getReadAvailable();

    public long getWriteAvailable();

    public long getAvgOperationSize(OperationType var1);

    public static class AvgOperationSize {
        private final long[] sizeSum;
        private final long[] count;

        public AvgOperationSize() {
            int size = OperationType.values().length;
            this.sizeSum = new long[size];
            this.count = new long[size];
            for (int i = 0; i < size; ++i) {
                this.sizeSum[i] = 0L;
                this.count[i] = 0L;
            }
        }

        public void addOperationSize(OperationType type, long size) {
            if (size > 0L) {
                int index;
                int n = index = type.ordinal();
                this.sizeSum[n] = this.sizeSum[n] + size;
                int n2 = index;
                this.count[n2] = this.count[n2] + 1L;
            }
        }

        public long getAvgOperationSize(OperationType type) {
            int index = type.ordinal();
            return this.count[index] > 0L ? this.sizeSum[index] / this.count[index] : 0L;
        }

        public long getOperationSize(OperationType type) {
            return this.sizeSum[type.ordinal()];
        }

        public void addGetResult(Result result) {
            long size = QuotaUtil.calculateResultSize(result);
            this.addOperationSize(OperationType.GET, size);
        }

        public void addScanResult(List<Result> results) {
            long size = QuotaUtil.calculateResultSize(results);
            this.addOperationSize(OperationType.SCAN, size);
        }

        public void addMutation(Mutation mutation) {
            long size = QuotaUtil.calculateMutationSize(mutation);
            this.addOperationSize(OperationType.MUTATE, size);
        }
    }

    public static enum OperationType {
        MUTATE,
        GET,
        SCAN;

    }
}

