/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.HasThread;

@InterfaceAudience.Private
public class Leases
extends HasThread {
    private static final Log LOG = LogFactory.getLog((String)Leases.class.getName());
    public static final int MIN_WAIT_TIME = 100;
    private final Map<String, Lease> leases = new ConcurrentHashMap<String, Lease>();
    protected final int leaseCheckFrequency;
    protected volatile boolean stopRequested = false;

    public Leases(int leaseCheckFrequency) {
        this.leaseCheckFrequency = leaseCheckFrequency;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long toWait = this.leaseCheckFrequency;
        Lease nextLease = null;
        long nextLeaseDelay = Long.MAX_VALUE;
        while (!this.stopRequested || this.stopRequested && !this.leases.isEmpty()) {
            try {
                if (nextLease != null) {
                    toWait = nextLease.getDelay(TimeUnit.MILLISECONDS);
                }
                toWait = Math.min((long)this.leaseCheckFrequency, toWait);
                toWait = Math.max(100L, toWait);
                Thread.sleep(toWait);
            }
            catch (InterruptedException e) {
                continue;
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Unexpected exception killed leases thread", e);
                break;
            }
            nextLease = null;
            nextLeaseDelay = Long.MAX_VALUE;
            Iterator<Map.Entry<String, Lease>> it = this.leases.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Lease> entry = it.next();
                Lease lease = entry.getValue();
                long thisLeaseDelay = lease.getDelay(TimeUnit.MILLISECONDS);
                if (thisLeaseDelay > 0L) {
                    if (nextLease != null && thisLeaseDelay >= nextLeaseDelay) continue;
                    nextLease = lease;
                    nextLeaseDelay = thisLeaseDelay;
                    continue;
                }
                if (lease.getListener() == null) {
                    LOG.error((Object)("lease listener is null for lease " + lease.getLeaseName()));
                } else {
                    lease.getListener().leaseExpired();
                }
                it.remove();
            }
        }
        this.close();
    }

    public void closeAfterLeasesExpire() {
        this.stopRequested = true;
    }

    public void close() {
        LOG.info((Object)(Thread.currentThread().getName() + " closing leases"));
        this.stopRequested = true;
        this.leases.clear();
        LOG.info((Object)(Thread.currentThread().getName() + " closed leases"));
    }

    public void createLease(String leaseName, int leaseTimeoutPeriod, LeaseListener listener) throws LeaseStillHeldException {
        this.addLease(new Lease(leaseName, leaseTimeoutPeriod, listener));
    }

    public void addLease(Lease lease) throws LeaseStillHeldException {
        if (this.stopRequested) {
            return;
        }
        if (this.leases.containsKey(lease.getLeaseName())) {
            throw new LeaseStillHeldException(lease.getLeaseName());
        }
        lease.resetExpirationTime();
        this.leases.put(lease.getLeaseName(), lease);
    }

    public void renewLease(String leaseName) throws LeaseException {
        if (this.stopRequested) {
            return;
        }
        Lease lease = this.leases.get(leaseName);
        if (lease == null) {
            throw new LeaseException("lease '" + leaseName + "' does not exist or has already expired");
        }
        lease.resetExpirationTime();
    }

    public void cancelLease(String leaseName) throws LeaseException {
        this.removeLease(leaseName);
    }

    Lease removeLease(String leaseName) throws LeaseException {
        Lease lease = this.leases.remove(leaseName);
        if (lease == null) {
            throw new LeaseException("lease '" + leaseName + "' does not exist");
        }
        return lease;
    }

    static class Lease
    implements Delayed {
        private final String leaseName;
        private final LeaseListener listener;
        private int leaseTimeoutPeriod;
        private long expirationTime;

        Lease(String leaseName, int leaseTimeoutPeriod, LeaseListener listener) {
            this.leaseName = leaseName;
            this.listener = listener;
            this.leaseTimeoutPeriod = leaseTimeoutPeriod;
            this.expirationTime = 0L;
        }

        public String getLeaseName() {
            return this.leaseName;
        }

        public LeaseListener getListener() {
            return this.listener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.hashCode() == obj.hashCode();
        }

        public int hashCode() {
            return this.leaseName.hashCode();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expirationTime - EnvironmentEdgeManager.currentTime(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long delta = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
            return this.equals(o) ? 0 : (delta > 0L ? 1 : -1);
        }

        public void resetExpirationTime() {
            this.expirationTime = EnvironmentEdgeManager.currentTime() + (long)this.leaseTimeoutPeriod;
        }
    }

    public static class LeaseStillHeldException
    extends IOException {
        private final String leaseName;

        public LeaseStillHeldException(String name) {
            this.leaseName = name;
        }

        public String getName() {
            return this.leaseName;
        }
    }
}

