/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.types.RawInteger;
import org.apache.hudi.org.apache.hadoop.hbase.types.RawStringTerminated;
import org.apache.hudi.org.apache.hadoop.hbase.types.Union2;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hudi.org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestUnion2 {
    @Test
    public void testEncodeDecode() {
        Integer intVal = 10;
        String strVal = "hello";
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(10);
        SampleUnion1 type = new SampleUnion1();
        type.encode((PositionedByteRange)buff, intVal);
        buff.setPosition(0);
        Assert.assertTrue((0 == intVal.compareTo((Integer)type.decodeA(buff)) ? 1 : 0) != 0);
        buff.setPosition(0);
        type.encode((PositionedByteRange)buff, strVal);
        buff.setPosition(0);
        Assert.assertTrue((0 == strVal.compareTo((String)type.decodeB(buff)) ? 1 : 0) != 0);
    }

    @Test
    public void testSkip() {
        Integer intVal = 10;
        String strVal = "hello";
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(10);
        SampleUnion1 type = new SampleUnion1();
        int len = type.encode((PositionedByteRange)buff, intVal);
        buff.setPosition(0);
        Assert.assertEquals((long)len, (long)type.skip(buff));
        buff.setPosition(0);
        len = type.encode((PositionedByteRange)buff, strVal);
        buff.setPosition(0);
        Assert.assertEquals((long)len, (long)type.skip(buff));
    }

    private static class SampleUnion1
    extends Union2<Integer, String> {
        private static final byte IS_INTEGER = 0;
        private static final byte IS_STRING = 1;

        public SampleUnion1() {
            super(new RawInteger(), new RawStringTerminated(Order.DESCENDING, "."));
        }

        @Override
        public int skip(PositionedByteRange src) {
            switch (src.get()) {
                case 0: {
                    return 1 + this.typeA.skip(src);
                }
                case 1: {
                    return 1 + this.typeB.skip(src);
                }
            }
            throw new IllegalArgumentException("Unrecognized encoding format.");
        }

        @Override
        public Object decode(PositionedByteRange src) {
            switch (src.get()) {
                case 0: {
                    return this.typeA.decode(src);
                }
                case 1: {
                    return this.typeB.decode(src);
                }
            }
            throw new IllegalArgumentException("Unrecognized encoding format.");
        }

        @Override
        public int encodedLength(Object val) {
            Integer i = null;
            String s = null;
            try {
                i = (Integer)val;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                s = (String)val;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (null != i) {
                return 1 + this.typeA.encodedLength(i);
            }
            if (null != s) {
                return 1 + this.typeB.encodedLength(s);
            }
            throw new IllegalArgumentException("val is not a valid member of this union.");
        }

        @Override
        public int encode(PositionedByteRange dst, Object val) {
            Integer i = null;
            String s = null;
            try {
                i = (Integer)val;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            try {
                s = (String)val;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (null != i) {
                dst.put((byte)0);
                return 1 + this.typeA.encode(dst, i);
            }
            if (null != s) {
                dst.put((byte)1);
                return 1 + this.typeB.encode(dst, s);
            }
            throw new IllegalArgumentException("val is not of a supported type.");
        }
    }
}

