/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

@SuppressWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="TODO: synchronization in here needs review!!!")
public class SortedList<E>
implements List<E>,
RandomAccess {
    private volatile List<E> list;
    private final Comparator<? super E> comparator;

    public SortedList(Comparator<? super E> comparator) {
        this.list = Collections.emptyList();
        this.comparator = comparator;
    }

    public SortedList(Collection<? extends E> c, Comparator<? super E> comparator) {
        this.list = Collections.unmodifiableList(new ArrayList<E>(c));
        this.comparator = comparator;
    }

    public List<E> get() {
        return this.list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public synchronized boolean add(E e) {
        ArrayList<E> newList = new ArrayList<E>(this.list);
        boolean changed = newList.add(e);
        if (changed) {
            Collections.sort(newList, this.comparator);
        }
        this.list = Collections.unmodifiableList(newList);
        return changed;
    }

    @Override
    public synchronized boolean remove(Object o) {
        ArrayList<E> newList = new ArrayList<E>(this.list);
        boolean changed = newList.remove(o);
        this.list = Collections.unmodifiableList(newList);
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        ArrayList<? extends E> newList = new ArrayList<E>(this.list);
        boolean changed = newList.addAll(c);
        if (changed) {
            Collections.sort(newList, this.comparator);
        }
        this.list = Collections.unmodifiableList(newList);
        return changed;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        ArrayList<? extends E> newList = new ArrayList<E>(this.list);
        boolean changed = newList.addAll(index, c);
        if (changed) {
            Collections.sort(newList, this.comparator);
        }
        this.list = Collections.unmodifiableList(newList);
        return changed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        ArrayList<E> newList = new ArrayList<E>(this.list);
        boolean changed = newList.removeAll(c);
        this.list = Collections.unmodifiableList(newList);
        return changed;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        ArrayList<E> newList = new ArrayList<E>(this.list);
        boolean changed = newList.retainAll(c);
        this.list = Collections.unmodifiableList(newList);
        return changed;
    }

    @Override
    public synchronized void clear() {
        this.list = Collections.emptyList();
    }

    @Override
    public synchronized E get(int index) {
        return this.list.get(index);
    }

    @Override
    public synchronized E set(int index, E element) {
        ArrayList<E> newList = new ArrayList<E>(this.list);
        E result = newList.set(index, element);
        Collections.sort(this.list, this.comparator);
        this.list = Collections.unmodifiableList(newList);
        return result;
    }

    @Override
    public synchronized void add(int index, E element) {
        ArrayList<E> newList = new ArrayList<E>(this.list);
        newList.add(index, element);
        Collections.sort(this.list, this.comparator);
        this.list = Collections.unmodifiableList(newList);
    }

    @Override
    public synchronized E remove(int index) {
        ArrayList<E> newList = new ArrayList<E>(this.list);
        E result = newList.remove(index);
        this.list = Collections.unmodifiableList(newList);
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

