/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.LoadBalancerProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class LoadBalancerTracker
extends ZooKeeperNodeTracker {
    private static final Log LOG = LogFactory.getLog(LoadBalancerTracker.class);

    public LoadBalancerTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.balancerZNode, abortable);
    }

    public boolean isBalancerOn() {
        byte[] upData = super.getData(false);
        try {
            return upData == null || this.parseFrom(upData).getBalancerOn();
        }
        catch (DeserializationException dex) {
            LOG.error((Object)("ZK state for LoadBalancer could not be parsed " + Bytes.toStringBinary(upData)));
            return false;
        }
    }

    public void setBalancerOn(boolean balancerOn) throws KeeperException {
        byte[] upData = this.toByteArray(balancerOn);
        try {
            ZKUtil.setData(this.watcher, this.watcher.balancerZNode, upData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch(this.watcher, this.watcher.balancerZNode, upData);
        }
        super.nodeDataChanged(this.watcher.balancerZNode);
    }

    private byte[] toByteArray(boolean isBalancerOn) {
        LoadBalancerProtos.LoadBalancerState.Builder builder = LoadBalancerProtos.LoadBalancerState.newBuilder();
        builder.setBalancerOn(isBalancerOn);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    private LoadBalancerProtos.LoadBalancerState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(pbBytes);
        LoadBalancerProtos.LoadBalancerState.Builder builder = LoadBalancerProtos.LoadBalancerState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, pbBytes, magicLen, pbBytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build();
    }
}

