/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.core.JsonParser;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.BeanProperty;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.JavaType;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class AtomicReferenceDeserializer
extends StdDeserializer<AtomicReference<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referencedType;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final JsonDeserializer<?> _valueDeserializer;

    public AtomicReferenceDeserializer(JavaType referencedType) {
        this(referencedType, null, null);
    }

    public AtomicReferenceDeserializer(JavaType referencedType, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(AtomicReference.class);
        this._referencedType = referencedType;
        this._valueDeserializer = deser;
        this._valueTypeDeserializer = typeDeser;
    }

    public AtomicReferenceDeserializer withResolved(TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        return new AtomicReferenceDeserializer(this._referencedType, typeDeser, valueDeser);
    }

    @Override
    public AtomicReference<?> getNullValue() {
        return new AtomicReference();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        if (deser == null) {
            deser = ctxt.findContextualValueDeserializer(this._referencedType, property);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    @Override
    public AtomicReference<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (this._valueTypeDeserializer != null) {
            return new AtomicReference<Object>(this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer));
        }
        return new AtomicReference(this._valueDeserializer.deserialize(jp, ctxt));
    }

    public Object[] deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return (Object[])typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }
}

