/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum DistributionMode {
    NONE("none"),
    HASH("hash"),
    RANGE("range");

    private final String modeName;

    private DistributionMode(String modeName) {
        this.modeName = modeName;
    }

    public String modeName() {
        return this.modeName;
    }

    public static DistributionMode fromName(String modeName) {
        Preconditions.checkNotNull((Object)modeName, (Object)"Name of distribution mode should not be null");
        return DistributionMode.valueOf(modeName.toUpperCase(Locale.ENGLISH));
    }
}

