/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode.control;

import com.facebook.airlift.bytecode.BytecodeBlock;
import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.BytecodeVisitor;
import com.facebook.airlift.bytecode.MethodGenerationContext;
import com.facebook.airlift.bytecode.ParameterizedType;
import com.facebook.airlift.bytecode.control.FlowControl;
import com.facebook.airlift.bytecode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public class TryCatch
implements FlowControl {
    private final String comment;
    private final BytecodeNode tryNode;
    private final BytecodeNode catchNode;
    private final String exceptionName;

    public TryCatch(BytecodeNode tryNode, BytecodeNode catchNode, ParameterizedType exceptionType) {
        this(null, tryNode, catchNode, exceptionType);
    }

    public TryCatch(String comment, BytecodeNode tryNode, BytecodeNode catchNode, ParameterizedType exceptionType) {
        this.comment = comment;
        this.tryNode = Objects.requireNonNull(tryNode, "tryNode is null");
        this.catchNode = Objects.requireNonNull(catchNode, "catchNode is null");
        this.exceptionName = exceptionType != null ? exceptionType.getClassName() : null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public BytecodeNode getTryNode() {
        return this.tryNode;
    }

    public BytecodeNode getCatchNode() {
        return this.catchNode;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        LabelNode tryStart = new LabelNode("tryStart");
        LabelNode tryEnd = new LabelNode("tryEnd");
        LabelNode handler = new LabelNode("handler");
        LabelNode done = new LabelNode("done");
        BytecodeBlock block = new BytecodeBlock();
        block.visitLabel(tryStart).append(this.tryNode).visitLabel(tryEnd).gotoLabel(done);
        block.visitLabel(handler).append(this.catchNode);
        block.visitLabel(done);
        block.accept(visitor, generationContext);
        visitor.visitTryCatchBlock(tryStart.getLabel(), tryEnd.getLabel(), handler.getLabel(), this.exceptionName);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.tryNode, (Object)this.catchNode);
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitTryCatch(parent, this);
    }
}

