/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode.control;

import com.facebook.airlift.bytecode.BytecodeBlock;
import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.BytecodeVisitor;
import com.facebook.airlift.bytecode.MethodGenerationContext;
import com.facebook.airlift.bytecode.control.FlowControl;
import com.facebook.airlift.bytecode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class WhileLoop
implements FlowControl {
    private final String comment;
    private final BytecodeBlock condition = new BytecodeBlock();
    private final BytecodeBlock body = new BytecodeBlock();
    private final LabelNode continueLabel = new LabelNode("continue");
    private final LabelNode endLabel = new LabelNode("end");

    public WhileLoop() {
        this.comment = null;
    }

    public WhileLoop(String format, Object ... args) {
        this.comment = String.format(format, args);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public LabelNode getContinueLabel() {
        return this.continueLabel;
    }

    public LabelNode getEndLabel() {
        return this.endLabel;
    }

    public BytecodeBlock condition() {
        return this.condition;
    }

    public WhileLoop condition(BytecodeNode node) {
        Preconditions.checkState((boolean)this.condition.isEmpty(), (Object)"condition already set");
        this.condition.append(node);
        return this;
    }

    public BytecodeBlock body() {
        return this.body;
    }

    public WhileLoop body(BytecodeNode node) {
        Preconditions.checkState((boolean)this.body.isEmpty(), (Object)"body already set");
        this.body.append(node);
        return this;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        Preconditions.checkState((!this.condition.isEmpty() ? 1 : 0) != 0, (Object)"WhileLoop does not have a condition set");
        BytecodeBlock block = new BytecodeBlock().visitLabel(this.continueLabel).append(this.condition).ifZeroGoto(this.endLabel).append(this.body).gotoLabel(this.continueLabel).visitLabel(this.endLabel);
        block.accept(visitor, generationContext);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.condition, (Object)this.body);
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitWhile(parent, this);
    }
}

