/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class AllManifestsTable
extends BaseMetadataTable {
    private static final Schema MANIFEST_FILE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"path", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"length", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"partition_spec_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)4, (String)"added_snapshot_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"added_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)6, (String)"existing_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)7, (String)"deleted_data_files_count", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)8, (String)"partition_summaries", (Type)Types.ListType.ofRequired((int)9, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)10, (String)"contains_null", (Type)Types.BooleanType.get()), Types.NestedField.required((int)11, (String)"contains_nan", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)12, (String)"lower_bound", (Type)Types.StringType.get()), Types.NestedField.optional((int)13, (String)"upper_bound", (Type)Types.StringType.get())})))});

    AllManifestsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".all_manifests");
    }

    AllManifestsTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    public TableScan newScan() {
        return new AllManifestsTableScan(this.operations(), this.table(), MANIFEST_FILE_SCHEMA);
    }

    public Schema schema() {
        return MANIFEST_FILE_SCHEMA;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_MANIFESTS;
    }

    static class ManifestListReadTask
    implements DataTask {
        private final FileIO io;
        private final Schema schema;
        private final PartitionSpec spec;
        private final FileScanTask manifestListTask;

        ManifestListReadTask(FileIO io, Schema schema, PartitionSpec spec, FileScanTask manifestListTask) {
            this.io = io;
            this.schema = schema;
            this.spec = spec;
            this.manifestListTask = manifestListTask;
        }

        public List<DeleteFile> deletes() {
            return this.manifestListTask.deletes();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CloseableIterable<StructLike> rows() {
            try (AvroIterable manifests = Avro.read(this.io.newInputFile(this.manifestListTask.file().path().toString())).rename("manifest_file", GenericManifestFile.class.getName()).rename("partitions", GenericPartitionFieldSummary.class.getName()).rename("r508", GenericPartitionFieldSummary.class.getName()).project(ManifestFile.schema()).classLoader(GenericManifestFile.class.getClassLoader()).reuseContainers(false).build();){
                CloseableIterable rowIterable = CloseableIterable.transform(manifests, manifest -> ManifestsTable.manifestFileToRow(this.spec, manifest));
                StructProjection projection = StructProjection.create((Schema)MANIFEST_FILE_SCHEMA, (Schema)this.schema);
                CloseableIterable closeableIterable = CloseableIterable.transform((CloseableIterable)rowIterable, arg_0 -> ((StructProjection)projection).wrap(arg_0));
                return closeableIterable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Cannot read manifest list file: %s", new Object[]{this.manifestListTask.file().path()});
            }
        }

        public DataFile file() {
            return this.manifestListTask.file();
        }

        public PartitionSpec spec() {
            return this.manifestListTask.spec();
        }

        public long start() {
            return 0L;
        }

        public long length() {
            return this.manifestListTask.length();
        }

        public Expression residual() {
            return this.manifestListTask.residual();
        }

        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of((Object)this);
        }
    }

    public static class AllManifestsTableScan
    extends BaseAllMetadataTableScan {
        AllManifestsTableScan(TableOperations ops, Table table, Schema fileSchema) {
            super(ops, table, fileSchema);
        }

        private AllManifestsTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new AllManifestsTableScan(ops, table, schema, context);
        }

        @Override
        public TableScan useSnapshot(long scanSnapshotId) {
            throw new UnsupportedOperationException("Cannot select snapshot: all_manifests is for all snapshots");
        }

        @Override
        public TableScan asOfTime(long timestampMillis) {
            throw new UnsupportedOperationException("Cannot select snapshot: all_manifests is for all snapshots");
        }

        @Override
        protected String tableType() {
            return MetadataTableType.ALL_MANIFESTS.name();
        }

        public long targetSplitSize() {
            return this.tableOps().current().propertyAsLong("read.split.metadata-target-size", 0x2000000L);
        }

        @Override
        protected CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            return CloseableIterable.withNoopClose((Iterable)Iterables.transform(ops.current().snapshots(), snap -> {
                if (snap.manifestListLocation() != null) {
                    True filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
                    ResidualEvaluator residuals = ResidualEvaluator.unpartitioned((Expression)filter);
                    DataFile manifestListAsDataFile = DataFiles.builder(PartitionSpec.unpartitioned()).withInputFile(ops.io().newInputFile(snap.manifestListLocation())).withRecordCount(1L).withFormat(FileFormat.AVRO).build();
                    return new ManifestListReadTask(ops.io(), this.schema(), this.table().spec(), new BaseFileScanTask(manifestListAsDataFile, null, schemaString, specString, residuals));
                }
                return StaticDataTask.of(ops.io().newInputFile(ops.current().metadataFileLocation()), MANIFEST_FILE_SCHEMA, this.schema(), snap.allManifests(), manifest -> ManifestsTable.manifestFileToRow(this.table().spec(), manifest));
            }));
        }
    }
}

