/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class BaseSnapshot
implements Snapshot {
    private static final long INITIAL_SEQUENCE_NUMBER = 0L;
    private final FileIO io;
    private final long snapshotId;
    private final Long parentId;
    private final long sequenceNumber;
    private final long timestampMillis;
    private final String manifestListLocation;
    private final String operation;
    private final Map<String, String> summary;
    private final Integer schemaId;
    private transient List<ManifestFile> allManifests = null;
    private transient List<ManifestFile> dataManifests = null;
    private transient List<ManifestFile> deleteManifests = null;
    private transient List<DataFile> cachedAdds = null;
    private transient List<DataFile> cachedDeletes = null;

    BaseSnapshot(FileIO io, long snapshotId, Integer schemaId, String ... manifestFiles) {
        this(io, snapshotId, null, System.currentTimeMillis(), null, null, schemaId, Lists.transform(Arrays.asList(manifestFiles), path -> new GenericManifestFile(io.newInputFile(path), 0)));
    }

    BaseSnapshot(FileIO io, long sequenceNumber, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, Integer schemaId, String manifestList) {
        this.io = io;
        this.sequenceNumber = sequenceNumber;
        this.snapshotId = snapshotId;
        this.parentId = parentId;
        this.timestampMillis = timestampMillis;
        this.operation = operation;
        this.summary = summary;
        this.schemaId = schemaId;
        this.manifestListLocation = manifestList;
    }

    BaseSnapshot(FileIO io, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, Integer schemaId, List<ManifestFile> dataManifests) {
        this(io, 0L, snapshotId, parentId, timestampMillis, operation, summary, schemaId, null);
        this.allManifests = dataManifests;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public Long parentId() {
        return this.parentId;
    }

    public long timestampMillis() {
        return this.timestampMillis;
    }

    public String operation() {
        return this.operation;
    }

    public Map<String, String> summary() {
        return this.summary;
    }

    public Integer schemaId() {
        return this.schemaId;
    }

    private void cacheManifests() {
        if (this.allManifests == null) {
            this.allManifests = ManifestLists.read(this.io.newInputFile(this.manifestListLocation));
        }
        if (this.dataManifests == null || this.deleteManifests == null) {
            this.dataManifests = ImmutableList.copyOf((Iterable)Iterables.filter(this.allManifests, manifest -> manifest.content() == ManifestContent.DATA));
            this.deleteManifests = ImmutableList.copyOf((Iterable)Iterables.filter(this.allManifests, manifest -> manifest.content() == ManifestContent.DELETES));
        }
    }

    public List<ManifestFile> allManifests() {
        if (this.allManifests == null) {
            this.cacheManifests();
        }
        return this.allManifests;
    }

    public List<ManifestFile> dataManifests() {
        if (this.dataManifests == null) {
            this.cacheManifests();
        }
        return this.dataManifests;
    }

    public List<ManifestFile> deleteManifests() {
        if (this.deleteManifests == null) {
            this.cacheManifests();
        }
        return this.deleteManifests;
    }

    public List<DataFile> addedFiles() {
        if (this.cachedAdds == null) {
            this.cacheChanges();
        }
        return this.cachedAdds;
    }

    public List<DataFile> deletedFiles() {
        if (this.cachedDeletes == null) {
            this.cacheChanges();
        }
        return this.cachedDeletes;
    }

    public String manifestListLocation() {
        return this.manifestListLocation;
    }

    private void cacheChanges() {
        ImmutableList.Builder adds = ImmutableList.builder();
        ImmutableList.Builder deletes = ImmutableList.builder();
        Iterable changedManifests = Iterables.filter(this.dataManifests(), manifest -> Objects.equal((Object)manifest.snapshotId(), (Object)this.snapshotId));
        try (CloseableIterable<ManifestEntry<DataFile>> entries = new ManifestGroup(this.io, changedManifests).ignoreExisting().entries();){
            block15: for (ManifestEntry entry : entries) {
                switch (entry.status()) {
                    case ADDED: {
                        adds.add((Object)((DataFile)((DataFile)entry.file()).copy()));
                        continue block15;
                    }
                    case DELETED: {
                        deletes.add((Object)((DataFile)((DataFile)entry.file()).copyWithoutStats()));
                        continue block15;
                    }
                }
                throw new IllegalStateException("Unexpected entry status, not added or deleted: " + entry);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close entries while caching changes", new Object[0]);
        }
        this.cachedAdds = adds.build();
        this.cachedDeletes = deletes.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BaseSnapshot) {
            BaseSnapshot other = (BaseSnapshot)o;
            return this.snapshotId == other.snapshotId() && Objects.equal((Object)this.parentId, (Object)other.parentId()) && this.sequenceNumber == other.sequenceNumber() && this.timestampMillis == other.timestampMillis() && Objects.equal((Object)this.schemaId, (Object)other.schemaId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.snapshotId, this.parentId, this.sequenceNumber, this.timestampMillis, this.schemaId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.snapshotId).add("timestamp_ms", this.timestampMillis).add("operation", (Object)this.operation).add("summary", this.summary).add("manifest-list", (Object)this.manifestListLocation).add("schema-id", (Object)this.schemaId).toString();
    }
}

