/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalDataTableScan;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.ThreadPools;

public class DataTableScan
extends BaseTableScan {
    static final ImmutableList<String> SCAN_COLUMNS = ImmutableList.of((Object)"snapshot_id", (Object)"file_path", (Object)"file_ordinal", (Object)"file_format", (Object)"block_size_in_bytes", (Object)"file_size_in_bytes", (Object)"record_count", (Object)"partition", (Object)"key_metadata");
    static final ImmutableList<String> SCAN_WITH_STATS_COLUMNS = ImmutableList.builder().addAll(SCAN_COLUMNS).add((Object[])new String[]{"value_counts", "null_value_counts", "nan_value_counts", "lower_bounds", "upper_bounds", "column_sizes"}).build();
    static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);

    public DataTableScan(TableOperations ops, Table table) {
        super(ops, table, table.schema());
    }

    protected DataTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        super(ops, table, schema, context);
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        Long scanSnapshotId = this.snapshotId();
        Preconditions.checkState((scanSnapshotId == null ? 1 : 0) != 0, (String)"Cannot enable incremental scan, scan-snapshot set to id=%s", (Object)scanSnapshotId);
        return new IncrementalDataTableScan(this.tableOps(), this.table(), this.schema(), this.context().fromSnapshotId(fromSnapshotId).toSnapshotId(toSnapshotId));
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkState((currentSnapshot != null ? 1 : 0) != 0, (String)"Cannot scan appends after %s, there is no current snapshot", (long)fromSnapshotId);
        return this.appendsBetween(fromSnapshotId, currentSnapshot.snapshotId());
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
        return new DataTableScan(ops, table, schema, context);
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean ignoreResiduals, boolean caseSensitive, boolean colStats) {
        ManifestGroup manifestGroup = new ManifestGroup(ops.io(), snapshot.dataManifests(), snapshot.deleteManifests()).caseSensitive(caseSensitive).select((List<String>)(colStats ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS)).filterData(rowFilter).specsById(ops.current().specsById()).ignoreDeleted();
        if (ignoreResiduals) {
            manifestGroup = manifestGroup.ignoreResiduals();
        }
        if (PLAN_SCANS_WITH_WORKER_POOL && snapshot.dataManifests().size() > 1) {
            manifestGroup = manifestGroup.planWith(ThreadPools.getWorkerPool());
        }
        return manifestGroup.planFiles();
    }

    public long targetSplitSize() {
        return this.tableOps().current().propertyAsLong("read.split.target-size", 0x8000000L);
    }
}

