/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;

final class JdbcUtil {
    protected static final String CATALOG_TABLE_NAME = "iceberg_tables";
    protected static final String CATALOG_NAME = "catalog_name";
    protected static final String TABLE_NAMESPACE = "table_namespace";
    protected static final String TABLE_NAME = "table_name";
    protected static final String METADATA_LOCATION = "metadata_location";
    protected static final String PREVIOUS_METADATA_LOCATION = "previous_metadata_location";
    public static final String DO_COMMIT_SQL = "UPDATE iceberg_tables SET metadata_location = ? , previous_metadata_location = ?  WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND metadata_location = ?";
    protected static final String CREATE_CATALOG_TABLE = "CREATE TABLE iceberg_tables(catalog_name VARCHAR(255) NOT NULL,table_namespace VARCHAR(255) NOT NULL,table_name VARCHAR(255) NOT NULL,metadata_location VARCHAR(5500),previous_metadata_location VARCHAR(5500),PRIMARY KEY (catalog_name, table_namespace, table_name))";
    protected static final String GET_TABLE_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? ";
    protected static final String LIST_TABLES_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ?";
    protected static final String RENAME_TABLE_SQL = "UPDATE iceberg_tables SET table_namespace = ? , table_name = ?  WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? ";
    protected static final String DROP_TABLE_SQL = "DELETE FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? ";
    protected static final String GET_NAMESPACE_SQL = "SELECT table_namespace FROM iceberg_tables WHERE catalog_name = ? AND table_namespace LIKE ? LIMIT 1";
    protected static final String LIST_NAMESPACES_SQL = "SELECT DISTINCT table_namespace FROM iceberg_tables WHERE catalog_name = ? AND table_namespace LIKE ?";
    protected static final String DO_COMMIT_CREATE_TABLE_SQL = "INSERT INTO iceberg_tables (catalog_name, table_namespace, table_name, metadata_location, previous_metadata_location)  VALUES (?,?,?,?,null)";
    private static final Joiner JOINER_DOT = Joiner.on((char)'.');
    private static final Splitter SPLITTER_DOT = Splitter.on((char)'.');

    private JdbcUtil() {
    }

    public static Namespace stringToNamespace(String namespace) {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (String)"Invalid namespace %s", (Object)namespace);
        return Namespace.of((String[])((String[])Iterables.toArray((Iterable)SPLITTER_DOT.split((CharSequence)namespace), String.class)));
    }

    public static String namespaceToString(Namespace namespace) {
        return JOINER_DOT.join((Object[])namespace.levels());
    }

    public static TableIdentifier stringToTableIdentifier(String tableNamespace, String tableName) {
        return TableIdentifier.of((Namespace)JdbcUtil.stringToNamespace(tableNamespace), (String)tableName);
    }
}

