/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.function.Function;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.util.BinPacking;

public class TableScanUtil {
    private TableScanUtil() {
    }

    public static boolean hasDeletes(CombinedScanTask task) {
        return task.files().stream().anyMatch(TableScanUtil::hasDeletes);
    }

    public static boolean hasDeletes(FileScanTask task) {
        return !task.deletes().isEmpty();
    }

    public static CloseableIterable<FileScanTask> splitFiles(CloseableIterable<FileScanTask> tasks, long splitSize) {
        Preconditions.checkArgument((splitSize > 0L ? 1 : 0) != 0, (String)"Invalid split size (negative or 0): %s", (long)splitSize);
        FluentIterable splitTasks = FluentIterable.from(tasks).transformAndConcat(input -> input.split(splitSize));
        return CloseableIterable.combine((Iterable)splitTasks, tasks);
    }

    public static CloseableIterable<CombinedScanTask> planTasks(CloseableIterable<FileScanTask> splitFiles, long splitSize, int lookback, long openFileCost) {
        Preconditions.checkArgument((splitSize > 0L ? 1 : 0) != 0, (String)"Invalid split size (negative or 0): %s", (long)splitSize);
        Preconditions.checkArgument((lookback > 0 ? 1 : 0) != 0, (String)"Invalid split planning lookback (negative or 0): %s", (int)lookback);
        Preconditions.checkArgument((openFileCost >= 0L ? 1 : 0) != 0, (String)"Invalid file open cost (negative): %s", (long)openFileCost);
        Function<FileScanTask, Long> weightFunc = file -> Math.max(file.length(), openFileCost);
        return CloseableIterable.transform((CloseableIterable)CloseableIterable.combine(new BinPacking.PackingIterable<FileScanTask>((Iterable<FileScanTask>)splitFiles, splitSize, lookback, weightFunc, true), splitFiles), BaseCombinedScanTask::new);
    }
}

