/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.Page;
import java.util.Optional;

public abstract class DataPage
extends Page {
    protected final int valueCount;
    private final long firstRowIndex;

    public DataPage(int compressedSize, int uncompressedSize, int valueCount) {
        this(compressedSize, uncompressedSize, valueCount, -1L);
    }

    DataPage(int compressedSize, int uncompressedSize, int valueCount, long firstRowIndex) {
        super(compressedSize, uncompressedSize);
        this.valueCount = valueCount;
        this.firstRowIndex = firstRowIndex;
    }

    public Optional<Long> getFirstRowIndex() {
        return this.firstRowIndex < 0L ? Optional.empty() : Optional.of(this.firstRowIndex);
    }

    public int getValueCount() {
        return this.valueCount;
    }
}

