/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.ParquetEncoding;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;

public class DataPageV2
extends DataPage {
    private final int rowCount;
    private final int nullCount;
    private final Slice repetitionLevels;
    private final Slice definitionLevels;
    private final ParquetEncoding dataEncoding;
    private final Slice slice;
    private final Statistics<?> statistics;
    private final boolean isCompressed;

    public DataPageV2(int rowCount, int nullCount, int valueCount, long firstRowIndex, Slice repetitionLevels, Slice definitionLevels, ParquetEncoding dataEncoding, Slice slice, int uncompressedSize, Statistics<?> statistics, boolean isCompressed) {
        super(repetitionLevels.length() + definitionLevels.length() + slice.length(), uncompressedSize, valueCount, firstRowIndex);
        this.rowCount = rowCount;
        this.nullCount = nullCount;
        this.repetitionLevels = Objects.requireNonNull(repetitionLevels, "repetitionLevels slice is null");
        this.definitionLevels = Objects.requireNonNull(definitionLevels, "definitionLevels slice is null");
        this.dataEncoding = dataEncoding;
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.statistics = statistics;
        this.isCompressed = isCompressed;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getNullCount() {
        return this.nullCount;
    }

    public Slice getRepetitionLevels() {
        return this.repetitionLevels;
    }

    public Slice getDefinitionLevels() {
        return this.definitionLevels;
    }

    public ParquetEncoding getDataEncoding() {
        return this.dataEncoding;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public Statistics<?> getStatistics() {
        return this.statistics;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", this.rowCount).add("nullCount", this.nullCount).add("repetitionLevels", (Object)this.repetitionLevels).add("definitionLevels", (Object)this.definitionLevels).add("dataEncoding", (Object)this.dataEncoding).add("slice", (Object)this.slice).add("statistics", this.statistics).add("isCompressed", this.isCompressed).add("valueCount", this.valueCount).add("compressedSize", this.compressedSize).add("uncompressedSize", this.uncompressedSize).add("firstRowIndex", this.getFirstRowIndex()).toString();
    }
}

