/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.parquet.batchreader.BytesUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.google.common.base.Preconditions;

public class BooleanPlainValuesDecoder
implements ValuesDecoder.BooleanValuesDecoder {
    private final byte[] byteBuffer;
    private final int bufferEnd;
    private int bufferOffset;
    private int currentByteOffset;
    private byte currentByte;

    public BooleanPlainValuesDecoder(byte[] byteBuffer, int bufferOffset, int bufferLength) {
        this.byteBuffer = byteBuffer;
        this.bufferEnd = bufferOffset + bufferLength;
        this.bufferOffset = bufferOffset;
    }

    @Override
    public void readNext(byte[] values, int offset, int length) {
        if (this.currentByteOffset > 0) {
            int readChunk = Math.min(length, 8 - this.currentByteOffset);
            byte inValue = this.currentByte;
            for (int i = 0; i < readChunk; ++i) {
                values[offset++] = (byte)(inValue >> this.currentByteOffset & 1);
                ++this.currentByteOffset;
            }
            length -= readChunk;
            this.currentByteOffset %= 8;
        }
        Preconditions.checkState((this.bufferOffset + length / 8 <= this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
        while (length >= 8) {
            BytesUtils.unpack8Values(this.byteBuffer[this.bufferOffset++], values, offset);
            length -= 8;
            offset += 8;
        }
        if (length > 0) {
            Preconditions.checkState((this.bufferOffset < this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
            byte inValue = this.byteBuffer[this.bufferOffset++];
            for (int i = 0; i < length; i = (int)((byte)(i + 1))) {
                values[offset++] = (byte)(inValue >> i & 1);
            }
            this.currentByte = inValue;
            this.currentByteOffset = length;
        }
    }

    @Override
    public void skip(int length) {
        int fullBytes;
        if (this.currentByteOffset > 0) {
            int readChunkSize = Math.min(length, 8 - this.currentByteOffset);
            length -= readChunkSize;
            this.currentByteOffset = (this.currentByteOffset + readChunkSize) % 8;
        }
        if ((fullBytes = length / 8) > 0) {
            Preconditions.checkState((this.bufferOffset + fullBytes <= this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
            this.bufferOffset += fullBytes;
        }
        if ((length %= 8) > 0) {
            Preconditions.checkState((this.bufferOffset < this.bufferEnd ? 1 : 0) != 0, (Object)"End of stream: invalid read request");
            this.currentByte = this.byteBuffer[this.bufferOffset++];
            this.currentByteOffset = length;
        }
    }
}

