/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetErrorCode;
import com.facebook.presto.parquet.batchreader.dictionary.BinaryBatchDictionary;
import com.facebook.presto.parquet.batchreader.dictionary.TimestampDictionary;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.dictionary.IntegerDictionary;
import com.facebook.presto.parquet.dictionary.LongDictionary;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ParquetDecodingException;

public class Dictionaries {
    private Dictionaries() {
    }

    public static Dictionary createDictionary(ColumnDescriptor columnDescriptor, DictionaryPage dictionaryPage) {
        try {
            switch (columnDescriptor.getPrimitiveType().getPrimitiveTypeName()) {
                case INT32: 
                case FLOAT: {
                    return new IntegerDictionary(dictionaryPage);
                }
                case INT64: 
                case DOUBLE: {
                    return new LongDictionary(dictionaryPage);
                }
                case INT96: {
                    return new TimestampDictionary(dictionaryPage);
                }
                case BINARY: {
                    return new BinaryBatchDictionary(dictionaryPage);
                }
            }
        }
        catch (Exception e) {
            throw new ParquetDecodingException("could not decode the dictionary for " + columnDescriptor, (Throwable)e);
        }
        throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_UNSUPPORTED_ENCODING, String.format("Dictionary encoding is not supported: %s", columnDescriptor));
    }
}

