/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetCompressionUtils;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

public class PageReader {
    private final CompressionCodecName codec;
    private final long valueCount;
    private final LinkedList<DataPage> compressedPages;
    private final DictionaryPage compressedDictionaryPage;
    private final OffsetIndex offsetIndex;
    private int pageIndex;

    public PageReader(CompressionCodecName codec, LinkedList<DataPage> compressedPages, DictionaryPage compressedDictionaryPage) throws IOException {
        this(codec, compressedPages, compressedDictionaryPage, null);
    }

    public PageReader(CompressionCodecName codec, LinkedList<DataPage> compressedPages, DictionaryPage compressedDictionaryPage, OffsetIndex offsetIndex) {
        this.codec = codec;
        this.compressedPages = compressedPages;
        this.compressedDictionaryPage = compressedDictionaryPage;
        int count = 0;
        for (DataPage page : compressedPages) {
            count += page.getValueCount();
        }
        this.valueCount = count;
        this.offsetIndex = offsetIndex;
        this.pageIndex = 0;
    }

    public long getTotalValueCount() {
        return this.valueCount;
    }

    public DataPage readPage() {
        if (this.compressedPages.isEmpty()) {
            return null;
        }
        DataPage compressedPage = this.compressedPages.removeFirst();
        try {
            long firstRowIndex = PageReader.getFirstRowIndex(this.pageIndex, this.offsetIndex);
            ++this.pageIndex;
            if (compressedPage instanceof DataPageV1) {
                DataPageV1 dataPageV1 = (DataPageV1)compressedPage;
                Slice slice = ParquetCompressionUtils.decompress(this.codec, dataPageV1.getSlice(), dataPageV1.getUncompressedSize());
                return new DataPageV1(slice, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), firstRowIndex, dataPageV1.getStatistics(), dataPageV1.getRepetitionLevelEncoding(), dataPageV1.getDefinitionLevelEncoding(), dataPageV1.getValueEncoding());
            }
            DataPageV2 dataPageV2 = (DataPageV2)compressedPage;
            if (!dataPageV2.isCompressed()) {
                return dataPageV2;
            }
            int uncompressedSize = Math.toIntExact(dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().length() - dataPageV2.getRepetitionLevels().length());
            Slice slice = ParquetCompressionUtils.decompress(this.codec, dataPageV2.getSlice(), uncompressedSize);
            return new DataPageV2(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), firstRowIndex, dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), slice, dataPageV2.getUncompressedSize(), dataPageV2.getStatistics(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not decompress page", e);
        }
    }

    public DictionaryPage readDictionaryPage() {
        if (this.compressedDictionaryPage == null) {
            return null;
        }
        try {
            return new DictionaryPage(ParquetCompressionUtils.decompress(this.codec, this.compressedDictionaryPage.getSlice(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading dictionary page", e);
        }
    }

    public static long getFirstRowIndex(int pageIndex, OffsetIndex offsetIndex) {
        return offsetIndex == null ? -1L : offsetIndex.getFirstRowIndex(pageIndex);
    }
}

