/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.ParquetDataSource;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;

public class ParquetColumnIndexStore
implements ColumnIndexStore {
    private static final IndexStore MISSING_INDEX_STORE = new IndexStore(){

        @Override
        public Optional<ColumnIndex> getColumnIndex() {
            return null;
        }

        @Override
        public Optional<OffsetIndex> getOffsetIndex() {
            return null;
        }
    };
    private static final ParquetColumnIndexStore EMPTY = new ParquetColumnIndexStore(null, new BlockMetaData(), Collections.emptySet()){

        @Override
        public ColumnIndex getColumnIndex(ColumnPath column) {
            return null;
        }

        @Override
        public OffsetIndex getOffsetIndex(ColumnPath column) {
            throw new ColumnIndexStore.MissingOffsetIndexException(column);
        }
    };
    private final ParquetDataSource dataSource;
    private final Map<ColumnPath, IndexStore> store;

    public static ColumnIndexStore create(ParquetDataSource dataSource, BlockMetaData block, Set<ColumnPath> paths) {
        try {
            return new ParquetColumnIndexStore(dataSource, block, paths);
        }
        catch (ColumnIndexStore.MissingOffsetIndexException e) {
            return EMPTY;
        }
    }

    private ParquetColumnIndexStore(ParquetDataSource dataSource, BlockMetaData block, Set<ColumnPath> paths) {
        this.dataSource = dataSource;
        HashMap<ColumnPath, IndexStore> store = new HashMap<ColumnPath, IndexStore>();
        for (ColumnChunkMetaData column : block.getColumns()) {
            ColumnPath path = column.getPath();
            if (!paths.contains(path)) continue;
            store.put(path, new PageIndexStore(column));
        }
        this.store = store;
    }

    public ColumnIndex getColumnIndex(ColumnPath column) {
        return this.store.getOrDefault(column, MISSING_INDEX_STORE).getColumnIndex().orElse(null);
    }

    public OffsetIndex getOffsetIndex(ColumnPath column) {
        return this.store.getOrDefault(column, MISSING_INDEX_STORE).getOffsetIndex().orElse(null);
    }

    private class PageIndexStore
    implements IndexStore {
        private final ColumnChunkMetaData columnChunkMetadata;
        private Optional<ColumnIndex> columnIndex;
        private boolean columnIndexRead;
        private final Optional<OffsetIndex> offsetIndex;

        PageIndexStore(ColumnChunkMetaData meta) {
            this.columnChunkMetadata = meta;
            try {
                this.offsetIndex = ParquetColumnIndexStore.this.dataSource.readOffsetIndex(meta);
            }
            catch (IOException e) {
                throw new ColumnIndexStore.MissingOffsetIndexException(meta.getPath());
            }
        }

        @Override
        public Optional<ColumnIndex> getColumnIndex() {
            if (!this.columnIndexRead) {
                try {
                    this.columnIndex = ParquetColumnIndexStore.this.dataSource.readColumnIndex(this.columnChunkMetadata);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.columnIndexRead = true;
            }
            return this.columnIndex;
        }

        @Override
        public Optional<OffsetIndex> getOffsetIndex() {
            return this.offsetIndex;
        }
    }

    private static interface IndexStore {
        public Optional<ColumnIndex> getColumnIndex();

        public Optional<OffsetIndex> getOffsetIndex();
    }
}

