/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MemoryTrackingContext {
    private final AggregatedMemoryContext userAggregateMemoryContext;
    private final AggregatedMemoryContext revocableAggregateMemoryContext;
    private final AggregatedMemoryContext systemAggregateMemoryContext;
    private LocalMemoryContext userLocalMemoryContext;
    private LocalMemoryContext revocableLocalMemoryContext;
    private LocalMemoryContext systemLocalMemoryContext;

    public MemoryTrackingContext(AggregatedMemoryContext userAggregateMemoryContext, AggregatedMemoryContext revocableAggregateMemoryContext, AggregatedMemoryContext systemAggregateMemoryContext) {
        this.userAggregateMemoryContext = Objects.requireNonNull(userAggregateMemoryContext, "userAggregateMemoryContext is null");
        this.revocableAggregateMemoryContext = Objects.requireNonNull(revocableAggregateMemoryContext, "revocableAggregateMemoryContext is null");
        this.systemAggregateMemoryContext = Objects.requireNonNull(systemAggregateMemoryContext, "systemAggregateMemoryContext is null");
    }

    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.userAggregateMemoryContext::close);
            closer.register(this.revocableAggregateMemoryContext::close);
            closer.register(this.systemAggregateMemoryContext::close);
            closer.register(this.userLocalMemoryContext::close);
            closer.register(this.revocableLocalMemoryContext::close);
            closer.register(this.systemLocalMemoryContext::close);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception closing memory tracking context", e);
        }
    }

    public LocalMemoryContext localUserMemoryContext() {
        Verify.verify((this.userLocalMemoryContext != null ? 1 : 0) != 0, (String)"local memory contexts are not initialized", (Object[])new Object[0]);
        return this.userLocalMemoryContext;
    }

    public LocalMemoryContext localSystemMemoryContext() {
        Verify.verify((this.systemLocalMemoryContext != null ? 1 : 0) != 0, (String)"local memory contexts are not initialized", (Object[])new Object[0]);
        return this.systemLocalMemoryContext;
    }

    public LocalMemoryContext localRevocableMemoryContext() {
        Verify.verify((this.revocableLocalMemoryContext != null ? 1 : 0) != 0, (String)"local memory contexts are not initialized", (Object[])new Object[0]);
        return this.revocableLocalMemoryContext;
    }

    public LocalMemoryContext newUserMemoryContext(String allocationTag) {
        return this.userAggregateMemoryContext.newLocalMemoryContext(allocationTag);
    }

    public LocalMemoryContext newSystemMemoryContext(String allocationTag) {
        return this.systemAggregateMemoryContext.newLocalMemoryContext(allocationTag);
    }

    public AggregatedMemoryContext aggregateUserMemoryContext() {
        return this.userAggregateMemoryContext;
    }

    public AggregatedMemoryContext aggregateRevocableMemoryContext() {
        return this.revocableAggregateMemoryContext;
    }

    public AggregatedMemoryContext newAggregateSystemMemoryContext() {
        return this.systemAggregateMemoryContext.newAggregatedMemoryContext();
    }

    public long getUserMemory() {
        return this.userAggregateMemoryContext.getBytes();
    }

    public long getRevocableMemory() {
        return this.revocableAggregateMemoryContext.getBytes();
    }

    public long getSystemMemory() {
        return this.systemAggregateMemoryContext.getBytes();
    }

    public MemoryTrackingContext newMemoryTrackingContext() {
        return new MemoryTrackingContext(this.userAggregateMemoryContext.newAggregatedMemoryContext(), this.revocableAggregateMemoryContext.newAggregatedMemoryContext(), this.systemAggregateMemoryContext.newAggregatedMemoryContext());
    }

    public void initializeLocalMemoryContexts(String allocationTag) {
        this.userLocalMemoryContext = this.userAggregateMemoryContext.newLocalMemoryContext(allocationTag);
        this.revocableLocalMemoryContext = this.revocableAggregateMemoryContext.newLocalMemoryContext(allocationTag);
        this.systemLocalMemoryContext = this.systemAggregateMemoryContext.newLocalMemoryContext(allocationTag);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("userAggregateMemoryContext", (Object)this.userAggregateMemoryContext).add("revocableAggregateMemoryContext", (Object)this.revocableAggregateMemoryContext).add("systemAggregateMemoryContext", (Object)this.systemAggregateMemoryContext).add("userLocalMemoryContext", (Object)this.userLocalMemoryContext).add("revocableLocalMemoryContext", (Object)this.revocableLocalMemoryContext).add("systemLocalMemoryContext", (Object)this.systemLocalMemoryContext).toString();
    }
}

