/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.hive.orc.OrcSerde;
import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.DwrfTableEncryptionProperties;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.EncryptionInformationSource;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.TableEncryptionProperties;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractDwrfEncryptionInformationSource
implements EncryptionInformationSource {
    @Override
    public Optional<Map<String, EncryptionInformation>> getReadEncryptionInformation(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns, Map<String, Partition> partitions) {
        Optional<DwrfTableEncryptionProperties> encryptionProperties = AbstractDwrfEncryptionInformationSource.getTableEncryptionProperties(table);
        if (!encryptionProperties.isPresent()) {
            return Optional.empty();
        }
        Optional<Map<String, String>> fieldToKeyReference = AbstractDwrfEncryptionInformationSource.getFieldToKeyReference(encryptionProperties.get(), requestedColumns);
        if (!fieldToKeyReference.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.getReadEncryptionInformationInternal(session, table, requestedColumns, partitions, fieldToKeyReference.get(), encryptionProperties.get()));
    }

    protected abstract Map<String, EncryptionInformation> getReadEncryptionInformationInternal(ConnectorSession var1, Table var2, Optional<Set<HiveColumnHandle>> var3, Map<String, Partition> var4, Map<String, String> var5, DwrfTableEncryptionProperties var6);

    @Override
    public Optional<EncryptionInformation> getReadEncryptionInformation(ConnectorSession session, Table table, Optional<Set<HiveColumnHandle>> requestedColumns) {
        Optional<DwrfTableEncryptionProperties> encryptionProperties = AbstractDwrfEncryptionInformationSource.getTableEncryptionProperties(table);
        if (!encryptionProperties.isPresent()) {
            return Optional.empty();
        }
        Optional<Map<String, String>> fieldToKeyReference = AbstractDwrfEncryptionInformationSource.getFieldToKeyReference(encryptionProperties.get(), requestedColumns);
        if (!fieldToKeyReference.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.getReadEncryptionInformationInternal(session, table, requestedColumns, fieldToKeyReference.get(), encryptionProperties.get()));
    }

    protected abstract EncryptionInformation getReadEncryptionInformationInternal(ConnectorSession var1, Table var2, Optional<Set<HiveColumnHandle>> var3, Map<String, String> var4, DwrfTableEncryptionProperties var5);

    @Override
    public Optional<EncryptionInformation> getWriteEncryptionInformation(ConnectorSession session, TableEncryptionProperties tableEncryptionProperties, String dbName, String tableName) {
        if (!(tableEncryptionProperties instanceof DwrfTableEncryptionProperties)) {
            return Optional.empty();
        }
        return Optional.of(this.getWriteEncryptionInformationInternal(session, (DwrfTableEncryptionProperties)tableEncryptionProperties, dbName, tableName));
    }

    protected abstract EncryptionInformation getWriteEncryptionInformationInternal(ConnectorSession var1, DwrfTableEncryptionProperties var2, String var3, String var4);

    private static Optional<Map<String, String>> getFieldToKeyReference(DwrfTableEncryptionProperties encryptionProperties, Optional<Set<HiveColumnHandle>> requestedColumns) {
        Object fieldToKeyReference;
        Optional<ColumnEncryptionInformation> columnEncryptionInformation = encryptionProperties.getColumnEncryptionInformation();
        Optional<String> encryptTable = encryptionProperties.getEncryptTable();
        if (encryptTable.isPresent()) {
            fieldToKeyReference = !requestedColumns.isPresent() || !requestedColumns.get().isEmpty() ? ImmutableMap.of((Object)"__TABLE__", (Object)encryptTable.get()) : ImmutableMap.of();
        } else if (columnEncryptionInformation.isPresent()) {
            Map allFieldsToKeyReference = columnEncryptionInformation.get().getColumnToKeyReference();
            Optional<Set> requestedColumnNames = requestedColumns.map(columns -> (ImmutableSet)columns.stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet()));
            fieldToKeyReference = (Map)allFieldsToKeyReference.entrySet().stream().filter(entry -> requestedColumnNames.map(columns -> columns.contains(((ColumnEncryptionInformation.ColumnWithStructSubfield)entry.getKey()).getColumnName())).orElse(true)).collect(ImmutableMap.toImmutableMap(entry -> ((ColumnEncryptionInformation.ColumnWithStructSubfield)entry.getKey()).toString(), Map.Entry::getValue));
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Neither of encryptColumn or encryptTable present. We should never hit this");
        }
        return Optional.of(fieldToKeyReference);
    }

    private static Optional<DwrfTableEncryptionProperties> getTableEncryptionProperties(Table table) {
        if (!OrcSerde.class.getName().equals(table.getStorage().getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        return DwrfTableEncryptionProperties.fromHiveTableProperties(table.getParameters());
    }
}

