/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.meta;

import alluxio.AbstractMasterClient;
import alluxio.client.meta.MetaMasterClient;
import alluxio.grpc.BackupPRequest;
import alluxio.grpc.BackupStatusPRequest;
import alluxio.grpc.CheckpointPOptions;
import alluxio.grpc.GetConfigReportPOptions;
import alluxio.grpc.GetMasterInfoPOptions;
import alluxio.grpc.MasterInfo;
import alluxio.grpc.MasterInfoField;
import alluxio.grpc.MetaMasterClientServiceGrpc;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.BackupStatus;
import alluxio.wire.ConfigCheckReport;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetryHandlingMetaMasterClient
extends AbstractMasterClient
implements MetaMasterClient {
    private static final Logger RPC_LOG = LoggerFactory.getLogger(MetaMasterClient.class);
    private MetaMasterClientServiceGrpc.MetaMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingMetaMasterClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.META_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "MetaMaster";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = MetaMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public BackupStatus backup(BackupPRequest backupRequest) throws IOException {
        return this.retryRPC(() -> BackupStatus.fromProto(this.mClient.backup(backupRequest)), RPC_LOG, "Backup", "backupRequest=%s", backupRequest);
    }

    @Override
    public BackupStatus getBackupStatus(UUID backupId) throws IOException {
        return this.retryRPC(() -> BackupStatus.fromProto(this.mClient.getBackupStatus(BackupStatusPRequest.newBuilder().setBackupId(backupId.toString()).build())), RPC_LOG, "GetBackupStatus", "backupId=%s", backupId);
    }

    @Override
    public ConfigCheckReport getConfigReport() throws IOException {
        return this.retryRPC(() -> ConfigCheckReport.fromProto(this.mClient.getConfigReport(GetConfigReportPOptions.getDefaultInstance()).getReport()), RPC_LOG, "GetConfigReport", "", new Object[0]);
    }

    @Override
    public MasterInfo getMasterInfo(Set<MasterInfoField> fields) throws IOException {
        return this.retryRPC(() -> this.mClient.getMasterInfo(GetMasterInfoPOptions.newBuilder().addAllFilter(fields).build()).getMasterInfo(), RPC_LOG, "GetMasterInfo", "fields=%s", fields);
    }

    @Override
    public String checkpoint() throws IOException {
        return this.retryRPC(() -> this.mClient.checkpoint(CheckpointPOptions.newBuilder().build()).getMasterHostname(), RPC_LOG, "Checkpoint", "", new Object[0]);
    }
}

