/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.concurrent.LockMode;
import alluxio.resource.AlluxioResourceLeakDetectorFactory;
import alluxio.resource.RWLockResource;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.netty.util.ResourceLeakDetector;
import alluxio.shaded.client.io.netty.util.ResourceLeakTracker;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RefCountLockResource
extends RWLockResource {
    private static final ResourceLeakDetector<RefCountLockResource> DETECTOR = AlluxioResourceLeakDetectorFactory.instance().newResourceLeakDetector(RefCountLockResource.class);
    private final AtomicInteger mRefCount;
    @Nullable
    private final ResourceLeakTracker<RefCountLockResource> mTracker = DETECTOR.track(this);

    public RefCountLockResource(ReentrantReadWriteLock lock, LockMode mode, boolean acquireLock, AtomicInteger refCount, boolean useTryLock) {
        super(lock, mode, acquireLock, useTryLock);
        this.mRefCount = Preconditions.checkNotNull(refCount, "Reference Counter can not be null");
    }

    @Override
    public void close() {
        super.close();
        if (this.mTracker != null) {
            this.mTracker.close(this);
        }
        this.mRefCount.decrementAndGet();
    }
}

