/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.shaded.client.com.fasterxml.jackson.annotation.JsonCreator;
import alluxio.shaded.client.com.fasterxml.jackson.annotation.JsonProperty;
import alluxio.shaded.client.com.google.common.base.Joiner;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.io.swagger.annotations.ApiModelProperty;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class TieredIdentity
implements Serializable {
    private static final long serialVersionUID = -1920596090085594788L;
    private final List<LocalityTier> mTiers;

    @JsonCreator
    public TieredIdentity(@JsonProperty(value="tiers") List<LocalityTier> tiers) {
        this.mTiers = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(tiers, "tiers"));
    }

    @ApiModelProperty(value="Tiers included in the tier identity")
    public List<LocalityTier> getTiers() {
        return this.mTiers;
    }

    public LocalityTier getTier(int i) {
        return this.mTiers.get(i);
    }

    public boolean topTiersMatch(TieredIdentity other) {
        return this.mTiers.get(0).equals(other.getTier(0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TieredIdentity)) {
            return false;
        }
        TieredIdentity that = (TieredIdentity)o;
        return this.mTiers.equals(that.mTiers);
    }

    public int hashCode() {
        return Objects.hashCode(this.mTiers);
    }

    public String toString() {
        String tiers = Joiner.on(", ").join(this.mTiers.stream().map(tier -> tier.getTierName() + "=" + tier.getValue()).collect(Collectors.toList()));
        return String.format("TieredIdentity(%s)", tiers);
    }

    public static final class LocalityTier
    implements Serializable {
        private static final long serialVersionUID = 7078638137905293841L;
        private final String mTierName;
        private final String mValue;

        @JsonCreator
        public LocalityTier(@JsonProperty(value="tierName") String tierName, @JsonProperty(value="value") @Nullable String value) {
            this.mTierName = Preconditions.checkNotNull(tierName, "tierName");
            this.mValue = value;
        }

        @ApiModelProperty(value="Name of the tier", example="host")
        public String getTierName() {
            return this.mTierName;
        }

        @Nullable
        @ApiModelProperty(value="Value of the tier name", example="localhost")
        public String getValue() {
            return this.mValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocalityTier)) {
                return false;
            }
            LocalityTier that = (LocalityTier)o;
            return this.mTierName.equals(that.mTierName) && Objects.equal(this.mValue, that.mValue);
        }

        public int hashCode() {
            return Objects.hashCode(this.mTierName, this.mValue);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("tierName", this.mTierName).add("value", this.mValue).toString();
        }
    }
}

