/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.expressions.UnboundPredicate;

public final class ExpressionConverter {
    private ExpressionConverter() {
    }

    public static Expression toIcebergExpression(TupleDomain<IcebergColumnHandle> tupleDomain) {
        if (tupleDomain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (!tupleDomain.getDomains().isPresent()) {
            return Expressions.alwaysFalse();
        }
        Map domainMap = (Map)tupleDomain.getDomains().get();
        True expression = Expressions.alwaysTrue();
        for (Map.Entry entry : domainMap.entrySet()) {
            IcebergColumnHandle columnHandle = (IcebergColumnHandle)entry.getKey();
            Domain domain = (Domain)entry.getValue();
            String columnName = columnHandle.getName();
            if (IcebergColumnHandle.isPushedDownSubfield(columnHandle)) {
                Subfield pushedDownSubfield = IcebergColumnHandle.getPushedDownSubfield(columnHandle);
                columnName = ExpressionConverter.pushdownColumnNameForSubfield(pushedDownSubfield);
            }
            expression = Expressions.and((Expression)expression, (Expression)ExpressionConverter.toIcebergExpression(columnName, columnHandle.getType(), domain));
        }
        return expression;
    }

    public static String pushdownColumnNameForSubfield(Subfield subfield) {
        return String.join((CharSequence)".", ParquetTypeUtils.columnPathFromSubfield((Subfield)subfield));
    }

    private static Expression toIcebergExpression(String columnName, Type type, Domain domain) {
        if (domain.isAll()) {
            return Expressions.alwaysTrue();
        }
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? Expressions.isNull((String)columnName) : Expressions.alwaysFalse();
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? Expressions.alwaysTrue() : Expressions.not((Expression)Expressions.isNull((String)columnName));
        }
        if (type instanceof ArrayType || type instanceof MapType || type instanceof RowType) {
            return Expressions.alwaysTrue();
        }
        ValueSet domainValues = domain.getValues();
        UnboundPredicate expression = null;
        if (domain.isNullAllowed()) {
            expression = Expressions.isNull((String)columnName);
        }
        if (domainValues instanceof SortedRangeSet) {
            List orderedRanges = ((SortedRangeSet)domainValues).getOrderedRanges();
            expression = (Expression)MoreObjects.firstNonNull((Object)expression, (Object)Expressions.alwaysFalse());
            for (Range range : orderedRanges) {
                Marker low = range.getLow();
                Marker high = range.getHigh();
                Marker.Bound lowBound = low.getBound();
                Marker.Bound highBound = high.getBound();
                if (lowBound == Marker.Bound.EXACTLY && highBound == Marker.Bound.EXACTLY) {
                    if (ExpressionConverter.getIcebergLiteralValue(type, low).equals(ExpressionConverter.getIcebergLiteralValue(type, high))) {
                        expression = Expressions.or((Expression)expression, (Expression)Expressions.equal((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, low)));
                        continue;
                    }
                    Expression between = Expressions.and((Expression)Expressions.greaterThanOrEqual((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, low)), (Expression)Expressions.lessThanOrEqual((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, high)));
                    expression = Expressions.or((Expression)expression, (Expression)between);
                    continue;
                }
                if (lowBound == Marker.Bound.EXACTLY && low.getValueBlock().isPresent()) {
                    expression = Expressions.or((Expression)expression, (Expression)Expressions.greaterThanOrEqual((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, low)));
                } else if (lowBound == Marker.Bound.ABOVE && low.getValueBlock().isPresent()) {
                    expression = Expressions.or((Expression)expression, (Expression)Expressions.greaterThan((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, low)));
                }
                if (highBound == Marker.Bound.EXACTLY && high.getValueBlock().isPresent()) {
                    if (low.getValueBlock().isPresent()) {
                        expression = Expressions.and((Expression)expression, (Expression)Expressions.lessThanOrEqual((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, high)));
                        continue;
                    }
                    expression = Expressions.or((Expression)expression, (Expression)Expressions.lessThanOrEqual((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, high)));
                    continue;
                }
                if (highBound != Marker.Bound.BELOW || !high.getValueBlock().isPresent()) continue;
                if (low.getValueBlock().isPresent()) {
                    expression = Expressions.and((Expression)expression, (Expression)Expressions.lessThan((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, high)));
                    continue;
                }
                expression = Expressions.or((Expression)expression, (Expression)Expressions.lessThan((String)columnName, (Object)ExpressionConverter.getIcebergLiteralValue(type, high)));
            }
            return expression;
        }
        throw new VerifyException("Did not expect a domain value set other than SortedRangeSet but got " + domainValues.getClass().getSimpleName());
    }

    private static Object getIcebergLiteralValue(Type type, Marker marker) {
        if (type instanceof IntegerType) {
            return Math.toIntExact((Long)marker.getValue());
        }
        if (type instanceof RealType) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)marker.getValue())));
        }
        if (type instanceof DateType) {
            return Math.toIntExact((Long)marker.getValue());
        }
        if (type instanceof TimestampType || type instanceof TimeType) {
            return TimeUnit.MILLISECONDS.toMicros((Long)marker.getValue());
        }
        if (type instanceof VarcharType) {
            return ((Slice)marker.getValue()).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return ByteBuffer.wrap(((Slice)marker.getValue()).getBytes());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            Object value = Objects.requireNonNull(marker.getValue(), "The value of the marker must be non-null");
            if (Decimals.isShortDecimal((Type)decimalType)) {
                Preconditions.checkArgument((boolean)(value instanceof Long), (String)"A short decimal should be represented by a Long value but was %s", (Object)value.getClass().getName());
                return BigDecimal.valueOf((Long)value).movePointLeft(decimalType.getScale());
            }
            Preconditions.checkArgument((boolean)(value instanceof Slice), (String)"A long decimal should be represented by a Slice value but was %s", (Object)value.getClass().getName());
            return new BigDecimal(Decimals.decodeUnscaledValue((Slice)((Slice)value)), decimalType.getScale());
        }
        return marker.getValue();
    }
}

