/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.iceberg.ColumnIdentity;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.spi.ColumnHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.types.Types;

public class IcebergColumnHandle
implements ColumnHandle {
    private final ColumnIdentity columnIdentity;
    private final Type type;
    private final Optional<String> comment;
    private final ColumnType columnType;
    private final List<Subfield> requiredSubfields;

    @JsonCreator
    public IcebergColumnHandle(@JsonProperty(value="columnIdentity") ColumnIdentity columnIdentity, @JsonProperty(value="type") Type type, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="columnType") ColumnType columnType, @JsonProperty(value="requiredSubfields") List<Subfield> requiredSubfields) {
        this.columnIdentity = Objects.requireNonNull(columnIdentity, "columnIdentity is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.requiredSubfields = Objects.requireNonNull(requiredSubfields, "requiredSubfields is null");
    }

    public IcebergColumnHandle(ColumnIdentity columnIdentity, Type type, Optional<String> comment) {
        this(columnIdentity, type, comment, ColumnType.REGULAR, (List<Subfield>)ImmutableList.of());
    }

    @JsonProperty
    public ColumnIdentity getColumnIdentity() {
        return this.columnIdentity;
    }

    @JsonProperty
    public int getId() {
        return this.columnIdentity.getId();
    }

    @JsonProperty
    public String getName() {
        return this.columnIdentity.getName();
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public List<Subfield> getRequiredSubfields() {
        return this.requiredSubfields;
    }

    public ColumnHandle withRequiredSubfields(List<Subfield> subfields) {
        if (IcebergColumnHandle.isPushedDownSubfield(this)) {
            return this;
        }
        return new IcebergColumnHandle(this.columnIdentity, this.type, this.comment, this.columnType, subfields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnIdentity, this.type, this.comment, this.columnType, this.requiredSubfields});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IcebergColumnHandle other = (IcebergColumnHandle)obj;
        return Objects.equals(this.columnIdentity, other.columnIdentity) && Objects.equals(this.type, other.type) && Objects.equals(this.comment, other.comment) && Objects.equals((Object)this.columnType, (Object)other.columnType) && Objects.equals(this.requiredSubfields, other.requiredSubfields);
    }

    public String toString() {
        if (this.requiredSubfields.isEmpty()) {
            return this.getId() + ":" + this.getName() + ":" + this.type.getDisplayName();
        }
        return this.getId() + ":" + this.getName() + ":" + this.type.getDisplayName() + ":" + (Object)((Object)this.columnType) + ":" + this.requiredSubfields;
    }

    public static IcebergColumnHandle primitiveIcebergColumnHandle(int id, String name, Type type, Optional<String> comment) {
        return new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity(id, name), type, comment);
    }

    public static IcebergColumnHandle create(Types.NestedField column, TypeManager typeManager) {
        return new IcebergColumnHandle(ColumnIdentity.createColumnIdentity(column), TypeConverter.toPrestoType(column.type(), typeManager), Optional.ofNullable(column.doc()));
    }

    public static Subfield getPushedDownSubfield(IcebergColumnHandle column) {
        Preconditions.checkArgument((boolean)IcebergColumnHandle.isPushedDownSubfield(column), (Object)String.format("not a valid pushed down subfield: type=%s, subfields=%s", new Object[]{column.getColumnType(), column.getRequiredSubfields()}));
        return (Subfield)Iterables.getOnlyElement(column.getRequiredSubfields());
    }

    public static boolean isPushedDownSubfield(IcebergColumnHandle column) {
        return column.getColumnType() == ColumnType.SYNTHESIZED && column.getRequiredSubfields().size() == 1;
    }

    public static IcebergColumnHandle getSynthesizedIcebergColumnHandle(String pushdownColumnName, Type pushdownColumnType, Subfield requiredSubfields) {
        return IcebergColumnHandle.getSynthesizedIcebergColumnHandle(pushdownColumnName, pushdownColumnType, (List<Subfield>)ImmutableList.of((Object)requiredSubfields));
    }

    public static IcebergColumnHandle getSynthesizedIcebergColumnHandle(String pushdownColumnName, Type pushdownColumnType, List<Subfield> requiredSubfields) {
        return new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity(-1, pushdownColumnName), pushdownColumnType, Optional.of("nested column pushdown"), ColumnType.SYNTHESIZED, requiredSubfields);
    }

    public static enum ColumnType {
        REGULAR,
        SYNTHESIZED;

    }
}

