/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.parquet.ParquetFileWriter;
import com.facebook.presto.iceberg.HdfsInputFile;
import com.facebook.presto.iceberg.IcebergFileWriter;
import com.facebook.presto.parquet.writer.ParquetWriterOptions;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class IcebergParquetFileWriter
extends ParquetFileWriter
implements IcebergFileWriter {
    private final Path outputPath;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsContext hdfsContext;

    public IcebergParquetFileWriter(OutputStream outputStream, Callable<Void> rollbackAction, List<String> fileColumnNames, List<Type> fileColumnTypes, MessageType messageType, Map<List<String>, Type> primitiveTypes, ParquetWriterOptions parquetWriterOptions, int[] fileInputColumnIndexes, CompressionCodecName compressionCodecName, Path outputPath, HdfsEnvironment hdfsEnvironment, HdfsContext hdfsContext) {
        super(outputStream, rollbackAction, fileColumnNames, fileColumnTypes, messageType, primitiveTypes, parquetWriterOptions, fileInputColumnIndexes, compressionCodecName);
        this.outputPath = Objects.requireNonNull(outputPath, "outputPath is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hdfsContext = Objects.requireNonNull(hdfsContext, "hdfsContext is null");
    }

    @Override
    public Metrics getMetrics() {
        return (Metrics)this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity().getUser(), () -> ParquetUtil.fileMetrics((InputFile)new HdfsInputFile(this.outputPath, this.hdfsEnvironment, this.hdfsContext), (MetricsConfig)MetricsConfig.getDefault()));
    }
}

