/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergSplit;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.types.Type;

public class IcebergSplitSource
implements ConnectorSplitSource {
    private CloseableIterable<FileScanTask> fileScanTaskIterable;
    private CloseableIterator<FileScanTask> fileScanTaskIterator;
    private final TableScan tableScan;
    private final Closer closer = Closer.create();
    private final double minimumAssignedSplitWeight;
    private final ConnectorSession session;

    public IcebergSplitSource(ConnectorSession session, TableScan tableScan, CloseableIterable<FileScanTask> fileScanTaskIterable, double minimumAssignedSplitWeight) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableScan = Objects.requireNonNull(tableScan, "tableScan is null");
        this.fileScanTaskIterable = Objects.requireNonNull(fileScanTaskIterable, "combinedScanIterable is null");
        this.fileScanTaskIterator = fileScanTaskIterable.iterator();
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        this.closer.register(fileScanTaskIterable);
        this.closer.register(this.fileScanTaskIterator);
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>();
        Iterator iterator = Iterators.limit(this.fileScanTaskIterator, (int)maxSize);
        while (iterator.hasNext()) {
            FileScanTask task = (FileScanTask)iterator.next();
            splits.add(this.toIcebergSplit(task));
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
    }

    public boolean isFinished() {
        return !this.fileScanTaskIterator.hasNext();
    }

    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ConnectorSplit toIcebergSplit(FileScanTask task) {
        return new IcebergSplit(((DataFile)task.file()).path().toString(), task.start(), task.length(), ((DataFile)task.file()).format(), (List<HostAddress>)ImmutableList.of(), IcebergSplitSource.getPartitionKeys(task), IcebergSessionProperties.getNodeSelectionStrategy(this.session), SplitWeight.fromProportion((double)Math.min(Math.max((double)task.length() / (double)this.tableScan.targetSplitSize(), this.minimumAssignedSplitWeight), 1.0)));
    }

    private static Map<Integer, String> getPartitionKeys(FileScanTask scanTask) {
        StructLike partition = ((DataFile)scanTask.file()).partition();
        PartitionSpec spec = scanTask.spec();
        Map<PartitionField, Integer> fieldToIndex = IcebergUtil.getIdentityPartitions(spec);
        HashMap partitionKeys = new HashMap();
        fieldToIndex.forEach((field, index) -> {
            int id = field.sourceId();
            Type type = spec.schema().findType(id);
            Class javaClass = type.typeId().javaClass();
            Object value = partition.get(index.intValue(), javaClass);
            if (value == null) {
                partitionKeys.put(id, null);
            } else {
                String partitionValue = type.typeId() == Type.TypeID.FIXED || type.typeId() == Type.TypeID.BINARY ? new String(((ByteBuffer)value).array(), StandardCharsets.UTF_8) : value.toString();
                partitionKeys.put(id, partitionValue);
            }
        });
        return Collections.unmodifiableMap(partitionKeys);
    }
}

