/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.TableType;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class IcebergTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final TableType tableType;
    private final Optional<Long> snapshotId;
    private final TupleDomain<IcebergColumnHandle> predicate;

    @JsonCreator
    public IcebergTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableType") TableType tableType, @JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="predicate") TupleDomain<IcebergColumnHandle> predicate) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public TupleDomain<IcebergColumnHandle> getPredicate() {
        return this.predicate;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public SchemaTableName getSchemaTableNameWithType() {
        return new SchemaTableName(this.schemaName, this.tableName + "$" + this.tableType.name().toLowerCase(Locale.ROOT));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergTableHandle that = (IcebergTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.tableType == that.tableType && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaName, this.tableName, this.tableType, this.snapshotId, this.predicate});
    }

    public String toString() {
        return this.getSchemaTableNameWithType() + "@" + this.snapshotId;
    }
}

