/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.util.PageListBuilder;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class ManifestsTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;

    public ManifestsTable(SchemaTableName tableName, Table icebergTable, Optional<Long> snapshotId) {
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.tableMetadata = new ConnectorTableMetadata(tableName, (List)ImmutableList.builder().add((Object)new ColumnMetadata("path", (com.facebook.presto.common.type.Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("length", (com.facebook.presto.common.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("partition_spec_id", (com.facebook.presto.common.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("added_snapshot_id", (com.facebook.presto.common.type.Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("added_data_files_count", (com.facebook.presto.common.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("existing_data_files_count", (com.facebook.presto.common.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("deleted_data_files_count", (com.facebook.presto.common.type.Type)IntegerType.INTEGER)).add((Object)new ColumnMetadata("partitions", (com.facebook.presto.common.type.Type)new ArrayType((com.facebook.presto.common.type.Type)RowType.from(Arrays.asList(RowType.field((String)"contains_null", (com.facebook.presto.common.type.Type)BooleanType.BOOLEAN), RowType.field((String)"lower_bound", (com.facebook.presto.common.type.Type)VarcharType.VARCHAR), RowType.field((String)"upper_bound", (com.facebook.presto.common.type.Type)VarcharType.VARCHAR)))))).build());
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (!this.snapshotId.isPresent()) {
            return new FixedPageSource((Iterable)ImmutableList.of());
        }
        return new FixedPageSource(ManifestsTable.buildPages(this.tableMetadata, this.icebergTable, this.snapshotId.get()));
    }

    private static List<Page> buildPages(ConnectorTableMetadata tableMetadata, Table icebergTable, long snapshotId) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(tableMetadata);
        Snapshot snapshot = icebergTable.snapshot(snapshotId);
        if (snapshot == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Snapshot ID [%s] does not exist for table: %s", snapshotId, icebergTable));
        }
        Map partitionSpecsById = icebergTable.specs();
        snapshot.allManifests(icebergTable.io()).forEach(file -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendVarchar(file.path());
            pagesBuilder.appendBigint(file.length());
            pagesBuilder.appendInteger(file.partitionSpecId());
            pagesBuilder.appendBigint(file.snapshotId());
            pagesBuilder.appendInteger(file.addedFilesCount());
            pagesBuilder.appendInteger(file.existingFilesCount());
            pagesBuilder.appendInteger(file.deletedFilesCount());
            ManifestsTable.writePartitionSummaries(pagesBuilder.nextColumn(), file.partitions(), (PartitionSpec)partitionSpecsById.get(file.partitionSpecId()));
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static void writePartitionSummaries(BlockBuilder arrayBlockBuilder, List<ManifestFile.PartitionFieldSummary> summaries, PartitionSpec partitionSpec) {
        BlockBuilder singleArrayWriter = arrayBlockBuilder.beginBlockEntry();
        for (int i = 0; i < summaries.size(); ++i) {
            ManifestFile.PartitionFieldSummary summary = summaries.get(i);
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            Type nestedType = ((Types.NestedField)partitionSpec.partitionType().fields().get(i)).type();
            BlockBuilder rowBuilder = singleArrayWriter.beginBlockEntry();
            BooleanType.BOOLEAN.writeBoolean(rowBuilder, summary.containsNull());
            VarcharType.VARCHAR.writeString(rowBuilder, field.transform().toHumanString(Conversions.fromByteBuffer((Type)nestedType, (ByteBuffer)summary.lowerBound())));
            VarcharType.VARCHAR.writeString(rowBuilder, field.transform().toHumanString(Conversions.fromByteBuffer((Type)nestedType, (ByteBuffer)summary.upperBound())));
            singleArrayWriter.closeEntry();
        }
        arrayBlockBuilder.closeEntry();
    }
}

