/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.optimizer;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableProperties;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.parquet.rule.ParquetDereferencePushDown;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iceberg.FileFormat;

public class IcebergParquetDereferencePushDown
extends ParquetDereferencePushDown {
    private final IcebergTransactionManager transactionManager;
    private final TypeManager typeManager;

    @Inject
    public IcebergParquetDereferencePushDown(IcebergTransactionManager transactionManager, RowExpressionService rowExpressionService, TypeManager typeManager) {
        super(rowExpressionService);
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    protected boolean isParquetDereferenceEnabled(ConnectorSession session, TableHandle tableHandle) {
        Preconditions.checkArgument((boolean)(tableHandle.getConnectorHandle() instanceof IcebergTableHandle), (Object)"Dereference pushdown into reader is not supported on a non-iceberg TableHandle");
        if (!IcebergSessionProperties.isParquetDereferencePushdownEnabled(session)) {
            return false;
        }
        ConnectorMetadata metadata = this.transactionManager.get(tableHandle.getTransaction());
        Preconditions.checkState((boolean)(metadata instanceof IcebergAbstractMetadata), (Object)"metadata must be IcebergAbstractMetadata");
        return FileFormat.PARQUET == IcebergTableProperties.getFileFormat(metadata.getTableMetadata(session, tableHandle.getConnectorHandle()).getProperties());
    }

    protected String getColumnName(ColumnHandle columnHandle) {
        Preconditions.checkArgument((boolean)(columnHandle instanceof IcebergColumnHandle), (Object)("Expected Iceberg column handle, instead got: " + columnHandle.getClass()));
        return ((IcebergColumnHandle)columnHandle).getName();
    }

    protected ColumnHandle createSubfieldColumnHandle(ColumnHandle baseColumnHandle, Subfield subfield, Type subfieldDataType, String subfieldColumnName) {
        Preconditions.checkArgument((boolean)(baseColumnHandle instanceof IcebergColumnHandle), (Object)("Expected Iceberg column handle, instead got: " + baseColumnHandle.getClass()));
        IcebergColumnHandle icebergBaseColumnHandle = (IcebergColumnHandle)baseColumnHandle;
        Type type = icebergBaseColumnHandle.getType();
        Preconditions.checkArgument((boolean)(type instanceof RowType), (String)"%s must be type of RowType", (Object)subfield.getRootName());
        Optional nestedColumnHiveType = TypeConverter.toHiveType(type).findChildType(subfield.getPath().stream().map(p -> ((Subfield.NestedField)p).getName()).collect(Collectors.toList()));
        if (!nestedColumnHiveType.isPresent()) {
            throw new IllegalArgumentException("nested column [" + subfield + "] type is not present in Hive column type");
        }
        Type pushdownColumnType = ((HiveType)nestedColumnHiveType.get()).getType(this.typeManager);
        return IcebergColumnHandle.getSynthesizedIcebergColumnHandle(subfieldColumnName, pushdownColumnType, (List<Subfield>)ImmutableList.of((Object)subfield));
    }
}

