/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.util;

import com.facebook.presto.spi.SchemaTableName;
import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;

public class IcebergPrestoModelConverters {
    private IcebergPrestoModelConverters() {
    }

    public static String toPrestoSchemaName(Namespace icebergNamespace) {
        return icebergNamespace.toString();
    }

    public static Namespace toIcebergNamespace(Optional<String> prestoSchemaName) {
        return prestoSchemaName.map(xva$0 -> Namespace.of((String[])new String[]{xva$0})).orElse(Namespace.empty());
    }

    public static SchemaTableName toPrestoSchemaTableName(TableIdentifier icebergTableIdentifier) {
        return new SchemaTableName(icebergTableIdentifier.namespace().toString(), icebergTableIdentifier.name());
    }

    public static TableIdentifier toIcebergTableIdentifier(SchemaTableName prestoSchemaTableName) {
        return IcebergPrestoModelConverters.toIcebergTableIdentifier(prestoSchemaTableName.getSchemaName(), prestoSchemaTableName.getTableName());
    }

    public static TableIdentifier toIcebergTableIdentifier(String prestoSchemaName, String prestoTableName) {
        return TableIdentifier.of((String[])new String[]{prestoSchemaName, prestoTableName});
    }
}

