/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public enum FileContent {
    DATA(0),
    POSITION_DELETES(1),
    EQUALITY_DELETES(2);

    private final int id;

    private FileContent(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public static FileContent fromIcebergFileContent(org.apache.iceberg.FileContent fileContent) {
        FileContent prestoFileContent;
        switch (fileContent) {
            case DATA: {
                prestoFileContent = DATA;
                break;
            }
            case POSITION_DELETES: {
                prestoFileContent = POSITION_DELETES;
                break;
            }
            case EQUALITY_DELETES: {
                prestoFileContent = EQUALITY_DELETES;
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported iceberg content type: " + fileContent);
            }
        }
        return prestoFileContent;
    }
}

