/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public enum FileFormat {
    ORC("orc", true),
    PARQUET("parquet", true),
    AVRO("avro", true),
    METADATA("metadata.json", false);

    private final String ext;
    private final boolean splittable;

    private FileFormat(String ext, boolean splittable) {
        this.ext = "." + ext;
        this.splittable = splittable;
    }

    public String addExtension(String filename) {
        if (filename.endsWith(this.ext)) {
            return filename;
        }
        return filename + this.ext;
    }

    public static FileFormat fromIcebergFileFormat(org.apache.iceberg.FileFormat format) {
        FileFormat prestoFileFormat;
        switch (format) {
            case ORC: {
                prestoFileFormat = ORC;
                break;
            }
            case PARQUET: {
                prestoFileFormat = PARQUET;
                break;
            }
            case AVRO: {
                prestoFileFormat = AVRO;
                break;
            }
            case METADATA: {
                prestoFileFormat = METADATA;
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported file format: " + format);
            }
        }
        return prestoFileFormat;
    }
}

