/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.iceberg.HdfsInputFile;
import com.facebook.presto.iceberg.HdfsOutputFile;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;

public class HdfsFileIO
implements FileIO {
    private final HdfsEnvironment environment;
    private final HdfsContext context;

    public HdfsFileIO(HdfsEnvironment environment, HdfsContext context) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    public InputFile newInputFile(String path) {
        return new HdfsInputFile(new Path(path), this.environment, this.context);
    }

    public OutputFile newOutputFile(String path) {
        return new HdfsOutputFile(new Path(path), this.environment, this.context);
    }

    public void deleteFile(String pathString) {
        Path path = new Path(pathString);
        try {
            this.environment.doAs(this.context.getIdentity().getUser(), () -> this.environment.getFileSystem(this.context, path).delete(path, false));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to delete file: " + path, (Throwable)e);
        }
    }
}

