/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.SqlTimestampWithTimeZone;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.BaseHiveTableLayoutHandle;
import com.facebook.presto.hive.HiveWrittenPartitions;
import com.facebook.presto.hive.MetadataUtils;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.ExpressionConverter;
import com.facebook.presto.iceberg.FilesTable;
import com.facebook.presto.iceberg.HistoryTable;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergMetadataColumn;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.IcebergWritableTableHandle;
import com.facebook.presto.iceberg.ManifestsTable;
import com.facebook.presto.iceberg.PartitionData;
import com.facebook.presto.iceberg.PartitionFields;
import com.facebook.presto.iceberg.PartitionTable;
import com.facebook.presto.iceberg.PropertiesTable;
import com.facebook.presto.iceberg.SnapshotsTable;
import com.facebook.presto.iceberg.TableStatisticsMaker;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.UnknownTableTypeException;
import com.facebook.presto.iceberg.changelog.ChangelogUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.connector.ConnectorTableVersion;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public abstract class IcebergAbstractMetadata
implements ConnectorMetadata {
    protected final TypeManager typeManager;
    protected final JsonCodec<CommitTaskData> commitTaskCodec;
    protected final NodeVersion nodeVersion;
    protected final RowExpressionService rowExpressionService;
    protected Transaction transaction;
    private final StandardFunctionResolution functionResolution;
    private final ConcurrentMap<SchemaTableName, Table> icebergTables = new ConcurrentHashMap<SchemaTableName, Table>();
    private static final Logger log = Logger.get(IcebergAbstractMetadata.class);

    public IcebergAbstractMetadata(TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, JsonCodec<CommitTaskData> commitTaskCodec, NodeVersion nodeVersion) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
    }

    protected final Table getIcebergTable(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.icebergTables.computeIfAbsent(schemaTableName, ignored -> this.getRawIcebergTable(session, schemaTableName));
    }

    protected abstract Table getRawIcebergTable(ConnectorSession var1, SchemaTableName var2);

    protected abstract boolean tableExists(ConnectorSession var1, SchemaTableName var2);

    protected abstract void registerTable(ConnectorSession var1, SchemaTableName var2, Path var3);

    protected abstract void unregisterTable(ConnectorSession var1, SchemaTableName var2);

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        Map predicateColumns = (Map)((Map)constraint.getSummary().getDomains().get()).keySet().stream().map(IcebergColumnHandle.class::cast).collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, (Function)Functions.identity()));
        IcebergTableHandle handle = (IcebergTableHandle)table;
        Table icebergTable = this.getIcebergTable(session, handle.getSchemaTableName());
        TupleDomain partitionColumnPredicate = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)constraint.getSummary().getDomains().get()), (Predicate)Predicates.in(IcebergUtil.getPartitionKeyColumnHandles(icebergTable, this.typeManager))));
        Optional<Set<IcebergColumnHandle>> requestedColumns = desiredColumns.map(columns -> (ImmutableSet)columns.stream().map(column -> (IcebergColumnHandle)((Object)((Object)column))).collect(ImmutableSet.toImmutableSet()));
        ConnectorTableLayout layout = this.getTableLayout(session, (ConnectorTableLayoutHandle)new IcebergTableLayoutHandle.Builder().setPartitionColumns((List<BaseHiveColumnHandle>)ImmutableList.copyOf(IcebergUtil.getPartitionKeyColumnHandles(icebergTable, this.typeManager))).setDataColumns(IcebergUtil.toHiveColumns(icebergTable.schema().columns())).setDomainPredicate((TupleDomain<Subfield>)constraint.getSummary().transform(IcebergAbstractMetadata::toSubfield)).setRemainingPredicate((RowExpression)LogicalRowExpressions.TRUE_CONSTANT).setPredicateColumns(predicateColumns).setRequestedColumns(requestedColumns).setPushdownFilterEnabled(IcebergSessionProperties.isPushdownFilterEnabled(session)).setPartitionColumnPredicate((TupleDomain<ColumnHandle>)partitionColumnPredicate).setPartitions(Optional.empty()).setTable(handle).build());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public static Subfield toSubfield(ColumnHandle columnHandle) {
        return new Subfield(((IcebergColumnHandle)columnHandle).getName(), (List)ImmutableList.of());
    }

    protected static boolean isEntireColumn(Subfield subfield) {
        return subfield.getPath().isEmpty();
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        ConstantExpression subfieldPredicate;
        TupleDomain predicate;
        IcebergTableLayoutHandle icebergTableLayoutHandle = (IcebergTableLayoutHandle)handle;
        IcebergTableHandle tableHandle = icebergTableLayoutHandle.getTable();
        if (!this.tableExists(session, tableHandle.getSchemaTableName())) {
            return null;
        }
        Table icebergTable = this.getIcebergTable(session, tableHandle.getSchemaTableName());
        IcebergUtil.validateTableMode(session, icebergTable);
        if (!IcebergSessionProperties.isPushdownFilterEnabled(session)) {
            return new ConnectorTableLayout(handle);
        }
        if (!icebergTableLayoutHandle.getPartitions().isPresent()) {
            return new ConnectorTableLayout((ConnectorTableLayoutHandle)icebergTableLayoutHandle, Optional.empty(), TupleDomain.none(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        }
        ImmutableList partitionColumns = ImmutableList.copyOf((Collection)icebergTableLayoutHandle.getPartitionColumns());
        List partitions = (List)icebergTableLayoutHandle.getPartitions().get();
        Optional discretePredicates = MetadataUtils.getDiscretePredicates((List)partitionColumns, (List)partitions);
        if (IcebergSessionProperties.isPushdownFilterEnabled(session)) {
            Map<String, ColumnHandle> predicateColumns = icebergTableLayoutHandle.getPredicateColumns().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            predicate = MetadataUtils.getPredicate((BaseHiveTableLayoutHandle)icebergTableLayoutHandle, (List)partitionColumns, (List)partitions, predicateColumns);
            Map columnTypes = (Map)IcebergUtil.getColumns(icebergTable.schema(), icebergTable.spec(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, icebergColumnHandle -> this.getColumnMetadata(session, (ConnectorTableHandle)tableHandle, (ColumnHandle)icebergColumnHandle).getType()));
            subfieldPredicate = MetadataUtils.getSubfieldPredicate((ConnectorSession)session, (BaseHiveTableLayoutHandle)icebergTableLayoutHandle, (Map)columnTypes, (StandardFunctionResolution)this.functionResolution, (RowExpressionService)this.rowExpressionService);
        } else {
            predicate = MetadataUtils.createPredicate((List)partitionColumns, (List)partitions);
            subfieldPredicate = LogicalRowExpressions.TRUE_CONSTANT;
        }
        RowExpression combinedRemainingPredicate = MetadataUtils.getCombinedRemainingPredicate((BaseHiveTableLayoutHandle)icebergTableLayoutHandle, (RowExpression)subfieldPredicate);
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)icebergTableLayoutHandle, Optional.empty(), predicate, Optional.empty(), Optional.empty(), discretePredicates, (List)ImmutableList.of(), Optional.of(combinedRemainingPredicate));
    }

    protected Optional<SystemTable> getIcebergSystemTable(SchemaTableName tableName, Table table) {
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        SchemaTableName systemTableName = new SchemaTableName(tableName.getSchemaName(), name.getTableNameWithType());
        Optional<Long> snapshotId = IcebergUtil.resolveSnapshotIdByName(table, name);
        switch (name.getTableType()) {
            case CHANGELOG: 
            case DATA: {
                break;
            }
            case HISTORY: {
                if (name.getSnapshotId().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for history table: " + systemTableName);
                }
                table.refresh();
                return Optional.of(new HistoryTable(systemTableName, table));
            }
            case SNAPSHOTS: {
                if (name.getSnapshotId().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for snapshots table: " + systemTableName);
                }
                table.refresh();
                return Optional.of(new SnapshotsTable(systemTableName, this.typeManager, table));
            }
            case PARTITIONS: {
                return Optional.of(new PartitionTable(systemTableName, this.typeManager, table, snapshotId));
            }
            case MANIFESTS: {
                return Optional.of(new ManifestsTable(systemTableName, table, snapshotId));
            }
            case FILES: {
                return Optional.of(new FilesTable(systemTableName, table, snapshotId, this.typeManager));
            }
            case PROPERTIES: {
                return Optional.of(new PropertiesTable(systemTableName, table));
            }
        }
        return Optional.empty();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)table;
        return this.getTableMetadata(session, icebergTableHandle.getSchemaTableName(), icebergTableHandle.getIcebergTableName());
    }

    protected ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName table, IcebergTableName icebergTableName) {
        Table icebergTable = this.getIcebergTable(session, new SchemaTableName(table.getSchemaName(), icebergTableName.getTableName()));
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll(this.getColumnMetadatas(icebergTable));
        if (icebergTableName.getTableType() == IcebergTableType.CHANGELOG) {
            return ChangelogUtil.getChangelogTableMeta(table, this.typeManager, (List<ColumnMetadata>)columns.build());
        }
        columns.add((Object)IcebergColumnHandle.PATH_COLUMN_METADATA);
        columns.add((Object)IcebergColumnHandle.DATA_SEQUENCE_NUMBER_COLUMN_METADATA);
        return new ConnectorTableMetadata(table, (List)columns.build(), this.createMetadataProperties(icebergTable), IcebergUtil.getTableComment(icebergTable));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List tables = prefix.getTableName() != null ? Collections.singletonList(prefix.toSchemaTableName()) : this.listTables(session, Optional.ofNullable(prefix.getSchemaName()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName table : tables) {
            try {
                IcebergTableName tableName = IcebergTableName.from(table.getTableName());
                if (tableName.isSystemTable()) continue;
                columns.put((Object)table, (Object)this.getTableMetadata(session, table, tableName).getColumns());
            }
            catch (TableNotFoundException e) {
                log.warn(String.format("table disappeared during listing operation: %s", e.getMessage()));
            }
            catch (UnknownTableTypeException e) {
                log.warn(String.format("%s: Unknown table type of table %s", e.getMessage(), table.getTableName()));
            }
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).setHidden(false).build();
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.finishInsert(session, (IcebergWritableTableHandle)tableHandle, fragments, computedStatistics);
    }

    protected ConnectorInsertTableHandle beginIcebergTableInsert(IcebergTableHandle table, Table icebergTable) {
        this.transaction = icebergTable.newTransaction();
        return new IcebergWritableTableHandle(table.getSchemaName(), table.getIcebergTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), icebergTable.spec(), this.typeManager), icebergTable.location(), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        if (fragments.isEmpty()) {
            this.transaction.commitTransaction();
            return Optional.empty();
        }
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(task.getPath()).withFileSizeInBytes(task.getFileSizeInBytes()).withFormat(FileFormat.fromString((String)table.getFileFormat().name())).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
        }
        appendFiles.commit();
        this.transaction.commitTransaction();
        return Optional.of(new HiveWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return IcebergColumnHandle.primitiveIcebergColumnHandle(0, "$row_id", (com.facebook.presto.common.type.Type)BigintType.BIGINT, Optional.empty());
    }

    public boolean isLegacyGetLayoutSupported(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return !IcebergSessionProperties.isPushdownFilterEnabled(session);
    }

    protected List<ColumnMetadata> getColumnMetadatas(Table table) {
        return (List)table.schema().columns().stream().map(column -> ColumnMetadata.builder().setName(column.name()).setType(TypeConverter.toPrestoType(column.type(), this.typeManager)).setComment(Optional.ofNullable(column.doc())).setHidden(false).build()).collect(ImmutableList.toImmutableList());
    }

    protected ImmutableMap<String, Object> createMetadataProperties(Table icebergTable) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"format", (Object)IcebergUtil.getFileFormat(icebergTable));
        int formatVersion = ((BaseTable)icebergTable).operations().current().formatVersion();
        properties.put((Object)"format_version", (Object)String.valueOf(formatVersion));
        if (!icebergTable.spec().fields().isEmpty()) {
            properties.put((Object)"partitioning", PartitionFields.toPartitionFields(icebergTable.spec()));
        }
        if (!icebergTable.location().isEmpty()) {
            properties.put((Object)"location", (Object)icebergTable.location());
        }
        return properties.build();
    }

    protected static Schema toIcebergSchema(List<ColumnMetadata> columns) {
        ArrayList<Types.NestedField> icebergColumns = new ArrayList<Types.NestedField>();
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            int index = icebergColumns.size();
            Type type = TypeConverter.toIcebergType(column.getType());
            Types.NestedField field = column.isNullable() ? Types.NestedField.optional((int)index, (String)column.getName(), (Type)type, (String)column.getComment()) : Types.NestedField.required((int)index, (String)column.getName(), (Type)type, (String)column.getComment());
            icebergColumns.add(field);
        }
        Types.StructType icebergSchema = Types.StructType.of(icebergColumns);
        AtomicInteger nextFieldId = new AtomicInteger(1);
        icebergSchema = TypeUtil.assignFreshIds((Type)icebergSchema, nextFieldId::getAndIncrement);
        return new Schema(icebergSchema.asStructType().fields());
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        return this.getTableHandle(session, tableName);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Set columnStatistics = (Set)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).flatMap(meta -> TableStatisticsMaker.getSupportedColumnStatistics(meta.getName(), meta.getType()).stream()).collect(ImmutableSet.toImmutableSet());
        ImmutableSet tableStatistics = ImmutableSet.of((Object)TableStatisticType.ROW_COUNT);
        return new TableStatisticsMetadata(columnStatistics, (Set)tableStatistics, Collections.emptyList());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.getIcebergTable(session, icebergTableHandle.getSchemaTableName());
        TableStatisticsMaker.writeTableStatistics(this.nodeVersion, icebergTableHandle, icebergTable, session, computedStatistics);
    }

    public void rollback() {
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        if (!column.isNullable()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support add column with non null");
        }
        Type columnType = TypeConverter.toIcebergType(column.getType());
        if (columnType.equals(Types.TimestampType.withZone())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Iceberg column type %s is not supported", columnType));
        }
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Verify.verify((handle.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can have columns added", (Object[])new Object[0]);
        Table icebergTable = this.getIcebergTable(session, handle.getSchemaTableName());
        Transaction transaction = icebergTable.newTransaction();
        transaction.updateSchema().addColumn(column.getName(), columnType, column.getComment()).commit();
        if (column.getProperties().containsKey("partitioning")) {
            String transform = (String)column.getProperties().get("partitioning");
            transaction.updateSpec().addField(PartitionFields.getPartitionColumnName(column.getName(), transform), PartitionFields.getTransformTerm(column.getName(), transform)).commit();
        }
        transaction.commitTransaction();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        Verify.verify((icebergTableHandle.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can have columns dropped", (Object[])new Object[0]);
        Table icebergTable = this.getIcebergTable(session, icebergTableHandle.getSchemaTableName());
        boolean shouldNotDropPartitionColumn = icebergTable.specs().values().stream().flatMap(partitionSpec -> partitionSpec.fields().stream()).anyMatch(field -> field.sourceId() == handle.getId());
        if (shouldNotDropPartitionColumn) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping columns which exist in any of the table's partition specs");
        }
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        Verify.verify((icebergTableHandle.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can have columns renamed", (Object[])new Object[0]);
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        Table icebergTable = this.getIcebergTable(session, icebergTableHandle.getSchemaTableName());
        Transaction transaction = icebergTable.newTransaction();
        transaction.updateSchema().renameColumn(columnHandle.getName(), target).commit();
        if (icebergTable.spec().fields().stream().map(PartitionField::sourceId).anyMatch(sourceId -> sourceId.intValue() == columnHandle.getId())) {
            transaction.updateSpec().renameField(columnHandle.getName(), target).commit();
        }
        transaction.commitTransaction();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Verify.verify((table.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can have data inserted", (Object[])new Object[0]);
        Table icebergTable = this.getIcebergTable(session, table.getSchemaTableName());
        IcebergUtil.validateTableMode(session, icebergTable);
        return this.beginIcebergTableInsert(table, icebergTable);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.getIcebergTable(session, table.getSchemaTableName());
        Schema schema = table.getIcebergTableName().getTableType() == IcebergTableType.CHANGELOG ? ChangelogUtil.changelogTableSchema(ChangelogUtil.getRowTypeFromColumnMeta(this.getColumnMetadatas(icebergTable))) : icebergTable.schema();
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (IcebergColumnHandle columnHandle : IcebergUtil.getColumns(schema, icebergTable.spec(), this.typeManager)) {
            columnHandles.put((Object)columnHandle.getName(), (Object)columnHandle);
        }
        if (table.getIcebergTableName().getTableType() != IcebergTableType.CHANGELOG) {
            columnHandles.put((Object)IcebergMetadataColumn.FILE_PATH.getColumnName(), (Object)IcebergColumnHandle.PATH_COLUMN_HANDLE);
            columnHandles.put((Object)IcebergMetadataColumn.DATA_SEQUENCE_NUMBER.getColumnName(), (Object)IcebergColumnHandle.DATA_SEQUENCE_NUMBER_COLUMN_HANDLE);
        }
        return columnHandles.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.getIcebergTable(session, handle.getSchemaTableName());
        return TableStatisticsMaker.getTableStatistics(session, constraint, handle, icebergTable, columnHandles.stream().map(IcebergColumnHandle.class::cast).collect(Collectors.toList()));
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.getTableHandle(session, tableName, Optional.empty());
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> tableVersion) {
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        Verify.verify((name.getTableType() == IcebergTableType.DATA || name.getTableType() == IcebergTableType.CHANGELOG || name.getTableType() == IcebergTableType.EQUALITY_DELETES ? 1 : 0) != 0, (String)("Wrong table type: " + (Object)((Object)name.getTableType())), (Object[])new Object[0]);
        if (!this.tableExists(session, tableName)) {
            return null;
        }
        Table table = this.getIcebergTable(session, new SchemaTableName(tableName.getSchemaName(), name.getTableName()));
        Optional tableSnapshotId = tableVersion.map(version -> {
            long tableVersionSnapshotId = IcebergAbstractMetadata.getSnapshotIdForTableVersion(table, version);
            return Optional.of(tableVersionSnapshotId);
        }).orElseGet(() -> IcebergUtil.resolveSnapshotIdByName(table, name));
        Optional<Schema> tableSchema = IcebergUtil.tryGetSchema(table);
        Optional<String> tableSchemaJson = tableSchema.map(SchemaParser::toJson);
        return new IcebergTableHandle(tableName.getSchemaName(), new IcebergTableName(name.getTableName(), name.getTableType(), tableSnapshotId, name.getChangelogEndSnapshot()), name.getSnapshotId().isPresent(), (TupleDomain<IcebergColumnHandle>)TupleDomain.all(), tableSchemaJson, Optional.empty(), Optional.empty());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        if (name.getTableType() == IcebergTableType.DATA || name.getTableType() == IcebergTableType.CHANGELOG) {
            return Optional.empty();
        }
        SchemaTableName icebergTableName = new SchemaTableName(tableName.getSchemaName(), name.getTableName());
        if (!this.tableExists(session, icebergTableName)) {
            return Optional.empty();
        }
        Table icebergTable = this.getIcebergTable(session, icebergTableName);
        if (name.getSnapshotId().isPresent() && icebergTable.snapshot(name.getSnapshotId().get().longValue()) == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, String.format("Invalid snapshot [%s] for table: %s", name.getSnapshotId().get(), icebergTable));
        }
        return this.getIcebergSystemTable(tableName, icebergTable);
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.getIcebergTable(session, handle.getSchemaTableName());
        try (CloseableIterable files = icebergTable.newScan().planFiles();){
            this.removeScanFiles(icebergTable, (Iterable<FileScanTask>)files);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "failed to scan files for delete", (Throwable)e);
        }
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        if (handle.isSnapshotSpecified()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector do not allow delete data at specified snapshot");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public boolean supportsMetadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        if (handle.isSnapshotSpecified()) {
            return false;
        }
        if (!tableLayoutHandle.isPresent()) {
            return true;
        }
        IcebergTableLayoutHandle layoutHandle = (IcebergTableLayoutHandle)tableLayoutHandle.get();
        TupleDomain domainPredicate = layoutHandle.getDomainPredicate().transform(subfield -> IcebergAbstractMetadata.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(layoutHandle.getPredicateColumns()::get).transform(ColumnHandle.class::cast);
        if (domainPredicate.isAll()) {
            return true;
        }
        Set predicateColumnIds = (Set)((Map)domainPredicate.getDomains().get()).keySet().stream().map(IcebergColumnHandle.class::cast).map(IcebergColumnHandle::getId).collect(ImmutableSet.toImmutableSet());
        Table icebergTable = this.getIcebergTable(session, handle.getSchemaTableName());
        boolean supportsMetadataDelete = true;
        for (PartitionSpec spec : icebergTable.specs().values()) {
            Set partitionColumnSourceIds = spec.fields().stream().filter(field -> field.transform().isIdentity()).map(PartitionField::sourceId).collect(Collectors.toSet());
            if (partitionColumnSourceIds.containsAll(predicateColumnIds)) continue;
            supportsMetadataDelete = false;
            break;
        }
        return supportsMetadataDelete;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OptionalLong metadataDelete(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorTableLayoutHandle tableLayoutHandle) {
        Table icebergTable;
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        IcebergTableLayoutHandle layoutHandle = (IcebergTableLayoutHandle)tableLayoutHandle;
        try {
            icebergTable = this.getIcebergTable(session, handle.getSchemaTableName());
        }
        catch (Exception e) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        TableScan scan = icebergTable.newScan();
        TupleDomain domainPredicate = layoutHandle.getDomainPredicate().transform(subfield -> IcebergAbstractMetadata.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(layoutHandle.getPredicateColumns()::get).transform(ColumnHandle.class::cast);
        if (!domainPredicate.isAll()) {
            Expression filterExpression = ExpressionConverter.toIcebergExpression(handle.getPredicate());
            scan = (TableScan)scan.filter(filterExpression);
        }
        try (CloseableIterable files = scan.planFiles();){
            OptionalLong optionalLong = OptionalLong.of(this.removeScanFiles(icebergTable, (Iterable<FileScanTask>)files));
            return optionalLong;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "failed to scan files for delete", (Throwable)e);
        }
    }

    private long removeScanFiles(Table icebergTable, Iterable<FileScanTask> scan) {
        this.transaction = icebergTable.newTransaction();
        DeleteFiles deletes = this.transaction.newDelete();
        AtomicLong rowsDeleted = new AtomicLong(0L);
        scan.forEach(t -> {
            deletes.deleteFile((DataFile)t.file());
            rowsDeleted.addAndGet(t.estimatedRowsCount());
        });
        deletes.commit();
        this.transaction.commitTransaction();
        return rowsDeleted.get();
    }

    private static long getSnapshotIdForTableVersion(Table table, ConnectorTableVersion tableVersion) {
        if (tableVersion.getVersionType() == ConnectorTableVersion.VersionType.TIMESTAMP) {
            if (tableVersion.getVersionExpressionType() instanceof TimestampWithTimeZoneType) {
                long millisUtc = new SqlTimestampWithTimeZone(((Long)tableVersion.getTableVersion()).longValue()).getMillisUtc();
                return IcebergUtil.getSnapshotIdAsOfTime(table, millisUtc);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported table version expression type: " + tableVersion.getVersionExpressionType());
        }
        if (tableVersion.getVersionType() == ConnectorTableVersion.VersionType.VERSION) {
            if (tableVersion.getVersionExpressionType() instanceof BigintType) {
                long snapshotId = (Long)tableVersion.getTableVersion();
                if (table.snapshot(snapshotId) == null) {
                    throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, "Iceberg snapshot ID does not exists: " + snapshotId);
                }
                return snapshotId;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported table version expression type: " + tableVersion.getVersionExpressionType());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported table version type: " + tableVersion.getVersionType());
    }
}

