/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.iceberg.ColumnIdentity;
import com.facebook.presto.iceberg.IcebergMetadataColumn;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.types.Types;

public class IcebergColumnHandle
extends BaseHiveColumnHandle {
    public static final IcebergColumnHandle PATH_COLUMN_HANDLE = IcebergColumnHandle.getIcebergColumnHandle(IcebergMetadataColumn.FILE_PATH);
    public static final ColumnMetadata PATH_COLUMN_METADATA = IcebergColumnHandle.getColumnMetadata(IcebergMetadataColumn.FILE_PATH);
    public static final IcebergColumnHandle DATA_SEQUENCE_NUMBER_COLUMN_HANDLE = IcebergColumnHandle.getIcebergColumnHandle(IcebergMetadataColumn.DATA_SEQUENCE_NUMBER);
    public static final ColumnMetadata DATA_SEQUENCE_NUMBER_COLUMN_METADATA = IcebergColumnHandle.getColumnMetadata(IcebergMetadataColumn.DATA_SEQUENCE_NUMBER);
    private final ColumnIdentity columnIdentity;
    private final Type type;

    @JsonCreator
    public IcebergColumnHandle(@JsonProperty(value="columnIdentity") ColumnIdentity columnIdentity, @JsonProperty(value="type") Type type, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="columnType") BaseHiveColumnHandle.ColumnType columnType, @JsonProperty(value="requiredSubfields") List<Subfield> requiredSubfields) {
        super(columnIdentity.getName(), comment, columnType, requiredSubfields);
        this.columnIdentity = Objects.requireNonNull(columnIdentity, "columnIdentity is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public IcebergColumnHandle(ColumnIdentity columnIdentity, Type type, Optional<String> comment, BaseHiveColumnHandle.ColumnType columnType) {
        this(columnIdentity, type, comment, columnType, (List<Subfield>)ImmutableList.of());
    }

    @JsonProperty
    public ColumnIdentity getColumnIdentity() {
        return this.columnIdentity;
    }

    @JsonProperty
    public int getId() {
        return this.columnIdentity.getId();
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonIgnore
    public boolean isRowPositionColumn() {
        return this.columnIdentity.getId() == MetadataColumns.ROW_POSITION.fieldId();
    }

    public ColumnHandle withRequiredSubfields(List<Subfield> subfields) {
        if (IcebergColumnHandle.isPushedDownSubfield(this)) {
            return this;
        }
        return new IcebergColumnHandle(this.columnIdentity, this.type, this.getComment(), this.getColumnType(), subfields);
    }

    public int hashCode() {
        return Objects.hash(this.columnIdentity, this.type, this.getComment(), this.getColumnType(), this.getRequiredSubfields());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IcebergColumnHandle other = (IcebergColumnHandle)((Object)obj);
        return Objects.equals(this.columnIdentity, other.columnIdentity) && Objects.equals(this.type, other.type) && Objects.equals(this.getComment(), other.getComment()) && Objects.equals(this.getColumnType(), other.getColumnType()) && Objects.equals(this.getRequiredSubfields(), other.getRequiredSubfields());
    }

    public String toString() {
        if (this.getRequiredSubfields().isEmpty()) {
            return this.getId() + ":" + this.getName() + ":" + this.type.getDisplayName();
        }
        return this.getId() + ":" + this.getName() + ":" + this.type.getDisplayName() + ":" + this.getColumnType() + ":" + this.getRequiredSubfields();
    }

    private static IcebergColumnHandle getIcebergColumnHandle(IcebergMetadataColumn metadataColumn) {
        return new IcebergColumnHandle(IcebergColumnHandle.columIdentity(metadataColumn), metadataColumn.getType(), Optional.empty(), BaseHiveColumnHandle.ColumnType.SYNTHESIZED);
    }

    private static ColumnMetadata getColumnMetadata(IcebergMetadataColumn metadataColumn) {
        return ColumnMetadata.builder().setName(metadataColumn.getColumnName()).setType(metadataColumn.getType()).setHidden(true).build();
    }

    private static ColumnIdentity columIdentity(IcebergMetadataColumn metadata) {
        return new ColumnIdentity(metadata.getId(), metadata.getColumnName(), metadata.getTypeCategory(), (List<ColumnIdentity>)ImmutableList.of());
    }

    public boolean isPathColumn() {
        return this.getColumnIdentity().getId() == IcebergMetadataColumn.FILE_PATH.getId();
    }

    public boolean isDataSequenceNumberColumn() {
        return this.getColumnIdentity().getId() == IcebergMetadataColumn.DATA_SEQUENCE_NUMBER.getId();
    }

    public static IcebergColumnHandle primitiveIcebergColumnHandle(int id, String name, Type type, Optional<String> comment) {
        return new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity(id, name), type, comment, BaseHiveColumnHandle.ColumnType.REGULAR);
    }

    public static IcebergColumnHandle create(Types.NestedField column, TypeManager typeManager, BaseHiveColumnHandle.ColumnType columnType) {
        return new IcebergColumnHandle(ColumnIdentity.createColumnIdentity(column), TypeConverter.toPrestoType(column.type(), typeManager), Optional.ofNullable(column.doc()), columnType);
    }

    public static Subfield getPushedDownSubfield(IcebergColumnHandle column) {
        Preconditions.checkArgument((boolean)IcebergColumnHandle.isPushedDownSubfield(column), (Object)String.format("not a valid pushed down subfield: type=%s, subfields=%s", column.getColumnType(), column.getRequiredSubfields()));
        return (Subfield)Iterables.getOnlyElement((Iterable)column.getRequiredSubfields());
    }

    public static boolean isPushedDownSubfield(IcebergColumnHandle column) {
        return column.getColumnType() == BaseHiveColumnHandle.ColumnType.SYNTHESIZED && column.getRequiredSubfields().size() == 1;
    }

    public static IcebergColumnHandle getSynthesizedIcebergColumnHandle(String pushdownColumnName, Type pushdownColumnType, Subfield requiredSubfields) {
        return IcebergColumnHandle.getSynthesizedIcebergColumnHandle(pushdownColumnName, pushdownColumnType, (List<Subfield>)ImmutableList.of((Object)requiredSubfields));
    }

    public static IcebergColumnHandle getSynthesizedIcebergColumnHandle(String pushdownColumnName, Type pushdownColumnType, List<Subfield> requiredSubfields) {
        return new IcebergColumnHandle(ColumnIdentity.primitiveColumnIdentity(-1, pushdownColumnName), pushdownColumnType, Optional.of("nested column pushdown"), BaseHiveColumnHandle.ColumnType.SYNTHESIZED, requiredSubfields);
    }
}

