/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergFileFormat;
import com.facebook.presto.iceberg.util.HiveStatisticsMergeStrategy;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.hadoop.HadoopFileIO;

public class IcebergConfig {
    private IcebergFileFormat fileFormat = IcebergFileFormat.PARQUET;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.GZIP;
    private CatalogType catalogType = CatalogType.HIVE;
    private String catalogWarehouse;
    private int catalogCacheSize = 10;
    private int maxPartitionsPerWriter = 100;
    private List<String> hadoopConfigResources = ImmutableList.of();
    private double minimumAssignedSplitWeight = 0.05;
    private boolean parquetDereferencePushdownEnabled = true;
    private boolean mergeOnReadModeEnabled = true;
    private double statisticSnapshotRecordDifferenceWeight;
    private boolean pushdownFilterEnabled;
    private boolean deleteAsJoinRewriteEnabled = true;
    private HiveStatisticsMergeStrategy hiveStatisticsMergeStrategy = HiveStatisticsMergeStrategy.NONE;
    private String fileIOImpl = HadoopFileIO.class.getName();
    private boolean manifestCachingEnabled;
    private long maxManifestCacheSize = 0x6400000L;
    private long manifestCacheExpireDuration = CatalogProperties.IO_MANIFEST_CACHE_EXPIRATION_INTERVAL_MS_DEFAULT;
    private long manifestCacheMaxContentLength = 0x800000L;

    @NotNull
    public FileFormat getFileFormat() {
        return FileFormat.valueOf(this.fileFormat.name());
    }

    @Config(value="iceberg.file-format")
    public IcebergConfig setFileFormat(IcebergFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="iceberg.compression-codec")
    public IcebergConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    @NotNull
    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    @Config(value="iceberg.catalog.type")
    @ConfigDescription(value="Iceberg catalog type")
    public IcebergConfig setCatalogType(CatalogType catalogType) {
        this.catalogType = catalogType;
        return this;
    }

    public String getCatalogWarehouse() {
        return this.catalogWarehouse;
    }

    @Config(value="iceberg.catalog.warehouse")
    @ConfigDescription(value="Iceberg catalog warehouse root path")
    public IcebergConfig setCatalogWarehouse(String catalogWarehouse) {
        this.catalogWarehouse = catalogWarehouse;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getCatalogCacheSize() {
        return this.catalogCacheSize;
    }

    @Config(value="iceberg.catalog.cached-catalog-num")
    @ConfigDescription(value="number of Iceberg catalog to cache across all sessions")
    public IcebergConfig setCatalogCacheSize(int catalogCacheSize) {
        this.catalogCacheSize = catalogCacheSize;
        return this;
    }

    public List<String> getHadoopConfigResources() {
        return this.hadoopConfigResources;
    }

    @Config(value="iceberg.hadoop.config.resources")
    @ConfigDescription(value="Comma separated paths to Hadoop configuration resource files")
    public IcebergConfig setHadoopConfigResources(String files) {
        if (files != null) {
            this.hadoopConfigResources = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        }
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="iceberg.max-partitions-per-writer")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public IcebergConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    @Config(value="iceberg.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned")
    public IcebergConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }

    @Config(value="iceberg.enable-parquet-dereference-pushdown")
    @ConfigDescription(value="enable parquet dereference pushdown")
    public IcebergConfig setParquetDereferencePushdownEnabled(boolean parquetDereferencePushdownEnabled) {
        this.parquetDereferencePushdownEnabled = parquetDereferencePushdownEnabled;
        return this;
    }

    public boolean isParquetDereferencePushdownEnabled() {
        return this.parquetDereferencePushdownEnabled;
    }

    @Config(value="iceberg.enable-merge-on-read-mode")
    @ConfigDescription(value="enable merge-on-read mode")
    public IcebergConfig setMergeOnReadModeEnabled(boolean mergeOnReadModeEnabled) {
        this.mergeOnReadModeEnabled = mergeOnReadModeEnabled;
        return this;
    }

    public boolean isMergeOnReadModeEnabled() {
        return this.mergeOnReadModeEnabled;
    }

    @Config(value="iceberg.hive-statistics-merge-strategy")
    @ConfigDescription(value="determines how to merge statistics that are stored in the Hive Metastore")
    public IcebergConfig setHiveStatisticsMergeStrategy(HiveStatisticsMergeStrategy mergeStrategy) {
        this.hiveStatisticsMergeStrategy = mergeStrategy;
        return this;
    }

    public HiveStatisticsMergeStrategy getHiveStatisticsMergeStrategy() {
        return this.hiveStatisticsMergeStrategy;
    }

    @Config(value="iceberg.statistic-snapshot-record-difference-weight")
    @ConfigDescription(value="the amount that the difference in total record count matters when calculating the closest snapshot when picking statistics. A value of 1 means a single record is equivalent to 1 millisecond of time difference.")
    public IcebergConfig setStatisticSnapshotRecordDifferenceWeight(double weight) {
        this.statisticSnapshotRecordDifferenceWeight = weight;
        return this;
    }

    public double getStatisticSnapshotRecordDifferenceWeight() {
        return this.statisticSnapshotRecordDifferenceWeight;
    }

    @Config(value="iceberg.pushdown-filter-enabled")
    @ConfigDescription(value="Experimental: Enable filter pushdown for Iceberg. This is only supported with Native Worker.")
    public IcebergConfig setPushdownFilterEnabled(boolean pushdownFilterEnabled) {
        this.pushdownFilterEnabled = pushdownFilterEnabled;
        return this;
    }

    public boolean isPushdownFilterEnabled() {
        return this.pushdownFilterEnabled;
    }

    @Config(value="iceberg.delete-as-join-rewrite-enabled")
    @ConfigDescription(value="When enabled, equality delete row filtering will be implemented by rewriting the query plan to join with the delete keys.")
    public IcebergConfig setDeleteAsJoinRewriteEnabled(boolean deleteAsJoinPushdownEnabled) {
        this.deleteAsJoinRewriteEnabled = deleteAsJoinPushdownEnabled;
        return this;
    }

    public boolean isDeleteAsJoinRewriteEnabled() {
        return this.deleteAsJoinRewriteEnabled;
    }

    public boolean getManifestCachingEnabled() {
        return this.manifestCachingEnabled;
    }

    @Config(value="iceberg.io.manifest.cache-enabled")
    @ConfigDescription(value="Enable/disable the manifest caching feature")
    public IcebergConfig setManifestCachingEnabled(boolean manifestCachingEnabled) {
        this.manifestCachingEnabled = manifestCachingEnabled;
        return this;
    }

    public String getFileIOImpl() {
        return this.fileIOImpl;
    }

    @NotNull
    @Config(value="iceberg.io-impl")
    @ConfigDescription(value="Custom FileIO implementation to use in a catalog")
    public IcebergConfig setFileIOImpl(String fileIOImpl) {
        this.fileIOImpl = fileIOImpl;
        return this;
    }

    public long getMaxManifestCacheSize() {
        return this.maxManifestCacheSize;
    }

    @Min(value=1L)
    @Config(value="iceberg.io.manifest.cache.max-total-bytes")
    @ConfigDescription(value="Maximum total amount of bytes to cache in the manifest cache")
    public @Min(value=1L) IcebergConfig setMaxManifestCacheSize(long maxManifestCacheSize) {
        this.maxManifestCacheSize = maxManifestCacheSize;
        return this;
    }

    public long getManifestCacheExpireDuration() {
        return this.manifestCacheExpireDuration;
    }

    @Min(value=0L)
    @Config(value="iceberg.io.manifest.cache.expiration-interval-ms")
    @ConfigDescription(value="Maximum duration for which an entry stays in the manifest cache")
    public @Min(value=0L) IcebergConfig setManifestCacheExpireDuration(long manifestCacheExpireDuration) {
        this.manifestCacheExpireDuration = manifestCacheExpireDuration;
        return this;
    }

    public long getManifestCacheMaxContentLength() {
        return this.manifestCacheMaxContentLength;
    }

    @Min(value=0L)
    @Config(value="iceberg.io.manifest.cache.max-content-length")
    @ConfigDescription(value="Maximum length of a manifest file to be considered for caching in bytes")
    public @Min(value=0L) IcebergConfig setManifestCacheMaxContentLength(long manifestCacheMaxContentLength) {
        this.manifestCacheMaxContentLength = manifestCacheMaxContentLength;
        return this;
    }
}

