/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.EmptyConnectorCommitHandle;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IcebergConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final IcebergTransactionManager transactionManager;
    private final IcebergMetadataFactory metadataFactory;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final Set<SystemTable> systemTables;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> schemaProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final List<PropertyMetadata<?>> columnProperties;
    private final ConnectorAccessControl accessControl;
    private final Set<Procedure> procedures;
    private final ConnectorPlanOptimizerProvider planOptimizerProvider;

    public IcebergConnector(LifeCycleManager lifeCycleManager, IcebergTransactionManager transactionManager, IcebergMetadataFactory metadataFactory, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorPageSinkProvider pageSinkProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, Set<SystemTable> systemTables, List<PropertyMetadata<?>> sessionProperties, List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> columnProperties, ConnectorAccessControl accessControl, Set<Procedure> procedures, ConnectorPlanOptimizerProvider planOptimizerProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.sessionProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
        this.schemaProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(schemaProperties, "schemaProperties is null"));
        this.tableProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableProperties, "tableProperties is null"));
        this.columnProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnProperties, "columnProperties is null"));
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.procedures = Objects.requireNonNull(procedures, "procedures is null");
        this.planOptimizerProvider = Objects.requireNonNull(planOptimizerProvider, "planOptimizerProvider is null");
    }

    public boolean isSingleStatementWritesOnly() {
        return true;
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return Sets.immutableEnumSet((Enum)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT, (Enum[])new ConnectorCapabilities[0]);
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        ConnectorMetadata metadata = this.transactionManager.get(transaction);
        return new ClassLoaderSafeConnectorMetadata(metadata, this.getClass().getClassLoader());
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.SERIALIZABLE, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.transactionManager.put((ConnectorTransactionHandle)transaction, this.metadataFactory.create());
        }
        return transaction;
    }

    public ConnectorCommitHandle commit(ConnectorTransactionHandle transaction) {
        this.transactionManager.remove(transaction);
        return EmptyConnectorCommitHandle.INSTANCE;
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        this.transactionManager.remove(transaction);
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return this.planOptimizerProvider;
    }
}

