/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveStatisticsUtil;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ViewAlreadyExistsException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Statistics;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.HdfsFileIO;
import com.facebook.presto.iceberg.HdfsInputFile;
import com.facebook.presto.iceberg.HiveTableOperations;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergSchemaProperties;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableProperties;
import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.IcebergWritableTableHandle;
import com.facebook.presto.iceberg.PartitionFields;
import com.facebook.presto.iceberg.TableStatisticsMaker;
import com.facebook.presto.iceberg.UnknownTableTypeException;
import com.facebook.presto.iceberg.util.HiveStatisticsMergeStrategy;
import com.facebook.presto.iceberg.util.StatisticsUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.joda.time.DateTimeZone;

public class IcebergHiveMetadata
extends IcebergAbstractMetadata {
    private final ExtendedHiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final DateTimeZone timeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(ZoneId.of(TimeZone.getDefault().getID())));
    private final FilterStatsCalculatorService filterStatsCalculatorService;

    public IcebergHiveMetadata(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, JsonCodec<CommitTaskData> commitTaskCodec, NodeVersion nodeVersion, FilterStatsCalculatorService filterStatsCalculatorService) {
        super(typeManager, functionResolution, rowExpressionService, commitTaskCodec, nodeVersion);
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.filterStatsCalculatorService = Objects.requireNonNull(filterStatsCalculatorService, "filterStatsCalculatorService is null");
    }

    public ExtendedHiveMetastore getMetastore() {
        return this.metastore;
    }

    @Override
    protected org.apache.iceberg.Table getRawIcebergTable(ConnectorSession session, SchemaTableName schemaTableName) {
        return IcebergUtil.getHiveIcebergTable(this.metastore, this.hdfsEnvironment, session, schemaTableName);
    }

    @Override
    protected boolean tableExists(ConnectorSession session, SchemaTableName schemaTableName) {
        IcebergTableName name = IcebergTableName.from(schemaTableName.getTableName());
        Optional hiveTable = this.metastore.getTable(this.getMetastoreContext(session), schemaTableName.getSchemaName(), name.getTableName());
        if (!hiveTable.isPresent()) {
            return false;
        }
        if (!IcebergUtil.isIcebergTable((Table)hiveTable.get())) {
            throw new UnknownTableTypeException(schemaTableName);
        }
        return true;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases(this.getMetastoreContext(session));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        List schemaNames = (List)schemaName.map(ImmutableList::of).orElseGet(() -> ImmutableList.copyOf(this.listSchemaNames(session)));
        return (List)schemaNames.stream().flatMap(schema -> this.metastore.getAllTables(metastoreContext, schema).orElseGet(() -> this.metastore.getAllDatabases(metastoreContext)).stream().map(table -> new SchemaTableName(schema, table))).collect(ImmutableList.toImmutableList());
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Optional<String> location = IcebergSchemaProperties.getSchemaLocation(properties).map(uri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsContext(session, schemaName), new Path(uri));
            }
            catch (IOException | IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + uri, (Throwable)e);
            }
            return uri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(PrincipalType.USER).setOwnerName(session.getUser()).build();
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        this.metastore.createDatabase(metastoreContext, database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, Optional.of(schemaName)).isEmpty() || !this.listViews(session, Optional.of(schemaName)).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        this.metastore.dropDatabase(metastoreContext, schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        this.metastore.renameDatabase(metastoreContext, source, target);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        String formatVersion;
        HiveTableOperations operations;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Schema schema = IcebergHiveMetadata.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        Database database = (Database)this.metastore.getDatabase(metastoreContext, schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        HdfsContext hdfsContext = new HdfsContext(session, schemaName, tableName);
        String targetPath = IcebergTableProperties.getTableLocation(tableMetadata.getProperties());
        if (targetPath == null) {
            Optional location = database.getLocation();
            if (!location.isPresent() || ((String)location.get()).isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Database " + schemaName + " location is not set");
            }
            Path databasePath = new Path((String)location.get());
            Path resultPath = new Path(databasePath, tableName);
            targetPath = resultPath.toString();
        }
        if ((operations = new HiveTableOperations(this.metastore, this.getMetastoreContext(session), this.hdfsEnvironment, hdfsContext, schemaName, tableName, session.getUser(), targetPath)).current() != null) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builderWithExpectedSize((int)3);
        FileFormat fileFormat = IcebergTableProperties.getFileFormat(tableMetadata.getProperties());
        propertiesBuilder.put((Object)"write.format.default", (Object)fileFormat.toString());
        if (tableMetadata.getComment().isPresent()) {
            propertiesBuilder.put((Object)"comment", tableMetadata.getComment().get());
        }
        if ((formatVersion = IcebergTableProperties.getFormatVersion(tableMetadata.getProperties())) != null) {
            propertiesBuilder.put((Object)"format-version", (Object)formatVersion);
        }
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (String)targetPath, (Map)propertiesBuilder.build());
        this.transaction = Transactions.createTableTransaction((String)tableName, (TableOperations)operations, (TableMetadata)metadata);
        return new IcebergWritableTableHandle(schemaName, new IcebergTableName(tableName, IcebergTableType.DATA, Optional.empty(), Optional.empty()), SchemaParser.toJson((Schema)metadata.schema()), PartitionSpecParser.toJson((PartitionSpec)metadata.spec()), IcebergUtil.getColumns(metadata.schema(), metadata.spec(), this.typeManager), targetPath, fileFormat, metadata.properties());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Verify.verify((handle.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can be dropped", (Object[])new Object[0]);
        org.apache.iceberg.Table table = this.getIcebergTable(session, handle.getSchemaTableName());
        Optional<Map<String, String>> tableProperties = IcebergUtil.tryGetProperties(table);
        if (tableProperties.isPresent() && (tableProperties.get().containsKey("write.object-storage.path") || tableProperties.get().containsKey("write.folder-storage.path") || tableProperties.get().containsKey("write.metadata.path") || tableProperties.get().containsKey("write.data.path"))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + handle.getSchemaTableName() + " contains Iceberg path override properties and cannot be dropped from Presto");
        }
        this.metastore.dropTable(this.getMetastoreContext(session), handle.getSchemaName(), handle.getIcebergTableName().getTableName(), true);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Verify.verify((handle.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can be renamed", (Object[])new Object[0]);
        this.metastore.renameTable(this.getMetastoreContext(session), handle.getSchemaName(), handle.getIcebergTableName().getTableName(), newTable.getSchemaName(), newTable.getTableName());
    }

    public void createView(ConnectorSession session, ConnectorTableMetadata viewMetadata, String viewData, boolean replace) {
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        SchemaTableName viewName = viewMetadata.getTable();
        Table table = MetastoreUtil.createTableObjectForViewCreation((ConnectorSession)session, (ConnectorTableMetadata)viewMetadata, IcebergUtil.createIcebergViewProperties(session, this.nodeVersion.toString()), (TypeTranslator)new HiveTypeTranslator(), (MetastoreContext)metastoreContext, (String)HiveUtil.encodeViewData((String)viewData));
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)session.getUser());
        Optional existing = this.metastore.getTable(metastoreContext, viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !MetastoreUtil.isPrestoView((Table)((Table)existing.get()))) {
                throw new ViewAlreadyExistsException(viewName);
            }
            this.metastore.replaceTable(metastoreContext, viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(metastoreContext, table, principalPrivileges);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        for (String schema : this.listSchemas(session, schemaName.orElse(null))) {
            for (String tableName : this.metastore.getAllViews(metastoreContext, schema).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schema, tableName));
            }
        }
        return tableNames.build();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder views = ImmutableMap.builder();
        ImmutableList tableNames = prefix.getTableName() != null ? ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName())) : this.listViews(session, Optional.of(prefix.getSchemaName()));
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        for (SchemaTableName schemaTableName : tableNames) {
            Optional table = this.metastore.getTable(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName());
            if (!table.isPresent() || !MetastoreUtil.isPrestoView((Table)((Table)table.get()))) continue;
            MetastoreUtil.verifyAndPopulateViews((Table)((Table)table.get()), (SchemaTableName)schemaTableName, (String)HiveUtil.decodeViewData((String)((String)((Table)table.get()).getViewOriginalText().get())), (ImmutableMap.Builder)views);
        }
        return views.build();
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition view = this.getViews(session, viewName.toSchemaTablePrefix()).get(viewName);
        MetastoreUtil.checkIfNullView((ConnectorViewDefinition)view, (SchemaTableName)viewName);
        try {
            this.metastore.dropTable(this.getMetastoreContext(session), viewName.getSchemaName(), viewName.getTableName(), true);
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    private MetastoreContext getMetastoreContext(ConnectorSession session) {
        return new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER, session.getWarningCollector());
    }

    private List<String> listSchemas(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return this.listSchemaNames(session);
        }
        return ImmutableList.of((Object)schemaNameOrNull);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        org.apache.iceberg.Table icebergTable = this.getIcebergTable(session, handle.getSchemaTableName());
        TableStatistics icebergStatistics = TableStatisticsMaker.getTableStatistics(session, constraint, handle, icebergTable, columnHandles.stream().map(IcebergColumnHandle.class::cast).collect(Collectors.toList()));
        HiveStatisticsMergeStrategy mergeStrategy = IcebergSessionProperties.getHiveStatisticsMergeStrategy(session);
        return tableLayoutHandle.map(IcebergTableLayoutHandle.class::cast).map(layoutHandle -> {
            TupleDomain domainPredicate = layoutHandle.getDomainPredicate().transform(subfield -> IcebergHiveMetadata.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(layoutHandle.getPredicateColumns()::get).transform(ColumnHandle.class::cast);
            TupleDomain predicate = domainPredicate.transform(icebergLayout -> {
                IcebergColumnHandle columnHandle = (IcebergColumnHandle)((Object)((Object)icebergLayout));
                return new VariableReferenceExpression(Optional.empty(), columnHandle.getName(), columnHandle.getType());
            });
            RowExpression translatedPredicate = this.rowExpressionService.getDomainTranslator().toPredicate(predicate);
            PartitionStatistics hiveStatistics = this.metastore.getTableStatistics(this.getMetastoreContext(session), handle.getSchemaName(), handle.getIcebergTableName().getTableName());
            TableStatistics mergedStatistics = StatisticsUtil.mergeHiveStatistics(icebergStatistics, hiveStatistics, mergeStrategy, icebergTable.spec());
            TableStatistics.Builder filteredStatsBuilder = TableStatistics.builder().setRowCount(mergedStatistics.getRowCount());
            double totalSize = 0.0;
            for (ColumnHandle colHandle : columnHandles) {
                IcebergColumnHandle icebergHandle = (IcebergColumnHandle)colHandle;
                if (!mergedStatistics.getColumnStatistics().containsKey((Object)icebergHandle)) continue;
                ColumnStatistics stats = (ColumnStatistics)mergedStatistics.getColumnStatistics().get((Object)icebergHandle);
                filteredStatsBuilder.setColumnStatistics((ColumnHandle)icebergHandle, stats);
                if (stats.getDataSize().isUnknown()) continue;
                totalSize += stats.getDataSize().getValue();
            }
            filteredStatsBuilder.setTotalSize(Estimate.of((double)totalSize));
            return this.filterStatsCalculatorService.filterStats(filteredStatsBuilder.build(), translatedPredicate, session, (Map)columnHandles.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableMap.toImmutableMap(col -> col, BaseHiveColumnHandle::getName)), (Map)columnHandles.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, IcebergColumnHandle::getType)));
        }).orElseGet(() -> {
            if (!mergeStrategy.equals((Object)HiveStatisticsMergeStrategy.NONE)) {
                PartitionStatistics hiveStats = this.metastore.getTableStatistics(this.getMetastoreContext(session), handle.getSchemaName(), handle.getIcebergTableName().getTableName());
                return StatisticsUtil.mergeHiveStatistics(icebergStatistics, hiveStats, mergeStrategy, icebergTable.spec());
            }
            return icebergStatistics;
        });
    }

    public IcebergTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        return this.getTableHandle(session, tableName);
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        Set columnStatistics = (Set)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).flatMap(meta -> this.metastore.getSupportedColumnStatistics(this.getMetastoreContext(session), meta.getType()).stream().map(statType -> statType.getColumnStatisticMetadata(meta.getName()))).collect(ImmutableSet.toImmutableSet());
        ImmutableSet tableStatistics = ImmutableSet.of((Object)TableStatisticType.ROW_COUNT);
        return new TableStatisticsMetadata(columnStatistics, (Set)tableStatistics, Collections.emptyList());
    }

    @Override
    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    @Override
    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        MetastoreContext metastoreContext = this.getMetastoreContext(session);
        Table table = (Table)this.metastore.getTable(metastoreContext, icebergTableHandle.getSchemaTableName().getSchemaName(), icebergTableHandle.getSchemaTableName().getTableName()).orElseThrow(() -> new TableNotFoundException(icebergTableHandle.getSchemaTableName()));
        List partitionColumns = table.getPartitionColumns();
        List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        List hiveColumnHandles = HiveUtil.hiveColumnHandles((Table)table);
        Map columnTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableMap.toImmutableMap(BaseHiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map computedStatisticsMap = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, (List)partitionColumnNames, (Map)columnTypes);
        PartitionStatistics tableStatistics = HiveStatisticsUtil.createPartitionStatistics((ConnectorSession)session, (Map)columnTypes, (ComputedStatistics)((ComputedStatistics)computedStatisticsMap.get(ImmutableList.of())), (DateTimeZone)this.timeZone);
        this.metastore.updateTableStatistics(metastoreContext, table.getDatabaseName(), table.getTableName(), oldStats -> HiveStatisticsUtil.updatePartitionStatistics((PartitionStatistics)oldStats, (PartitionStatistics)tableStatistics));
    }

    @Override
    public void registerTable(ConnectorSession clientSession, SchemaTableName schemaTableName, Path metadataLocation) {
        TableMetadata tableMetadata;
        String tableLocation = metadataLocation.getName();
        HdfsContext hdfsContext = new HdfsContext(clientSession, schemaTableName.getSchemaName(), schemaTableName.getTableName(), tableLocation, true);
        HdfsInputFile inputFile = new HdfsInputFile(metadataLocation, this.hdfsEnvironment, hdfsContext);
        try {
            tableMetadata = TableMetadataParser.read((FileIO)new HdfsFileIO(this.hdfsEnvironment, hdfsContext), (InputFile)inputFile);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Unable to read metadata file %s", metadataLocation), (Throwable)e);
        }
        Table.Builder builder = Table.builder().setDatabaseName(schemaTableName.getSchemaName()).setTableName(schemaTableName.getTableName()).setOwner(clientSession.getUser()).setDataColumns(IcebergUtil.toHiveColumns(tableMetadata.schema().columns())).setTableType(PrestoTableType.EXTERNAL_TABLE).withStorage(storage -> storage.setLocation(tableMetadata.location())).withStorage(storage -> storage.setStorageFormat(HiveTableOperations.STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("table_type", "iceberg".toUpperCase(Locale.ENGLISH)).setParameter("metadata_location", tableMetadata.metadataFileLocation());
        Table table = builder.build();
        PrestoPrincipal owner = new PrestoPrincipal(PrincipalType.USER, table.getOwner());
        PrincipalPrivileges privileges = new PrincipalPrivileges((Multimap)ImmutableMultimap.builder().put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, owner, owner)).put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true, owner, owner)).put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true, owner, owner)).put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true, owner, owner)).build(), (Multimap)ImmutableMultimap.of());
        MetastoreContext metastoreContext = this.getMetastoreContext(clientSession);
        this.metastore.createTable(metastoreContext, table, privileges);
    }

    @Override
    public void unregisterTable(ConnectorSession clientSession, SchemaTableName schemaTableName) {
        MetastoreContext metastoreContext = this.getMetastoreContext(clientSession);
        this.metastore.dropTableFromMetastore(metastoreContext, schemaTableName.getSchemaName(), schemaTableName.getTableName());
    }
}

