/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergHiveMetadata;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterStatsCalculatorService;
import com.facebook.presto.spi.relation.RowExpressionService;
import java.util.Objects;
import javax.inject.Inject;

public class IcebergHiveMetadataFactory
implements IcebergMetadataFactory {
    final ExtendedHiveMetastore metastore;
    final HdfsEnvironment hdfsEnvironment;
    final TypeManager typeManager;
    final JsonCodec<CommitTaskData> commitTaskCodec;
    final StandardFunctionResolution functionResolution;
    final RowExpressionService rowExpressionService;
    final NodeVersion nodeVersion;
    final FilterStatsCalculatorService filterStatsCalculatorService;

    @Inject
    public IcebergHiveMetadataFactory(IcebergConfig config, ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, JsonCodec<CommitTaskData> commitTaskCodec, NodeVersion nodeVersion, FilterStatsCalculatorService filterStatsCalculatorService) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.filterStatsCalculatorService = Objects.requireNonNull(filterStatsCalculatorService, "filterStatsCalculatorService is null");
        Objects.requireNonNull(config, "config is null");
    }

    @Override
    public ConnectorMetadata create() {
        return new IcebergHiveMetadata(this.metastore, this.hdfsEnvironment, this.typeManager, this.functionResolution, this.rowExpressionService, this.commitTaskCodec, this.nodeVersion, this.filterStatsCalculatorService);
    }
}

