/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveMetastoreCacheStats;
import com.facebook.presto.hive.metastore.HiveMetastoreModule;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.MetastoreCacheStats;
import com.facebook.presto.hive.metastore.MetastoreConfig;
import com.facebook.presto.iceberg.IcebergHiveMetadataFactory;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Optional;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class IcebergHiveModule
extends AbstractConfigurationAwareModule {
    private final String connectorId;
    private final Optional<ExtendedHiveMetastore> metastore;

    public IcebergHiveModule(String connectorId, Optional<ExtendedHiveMetastore> metastore) {
        this.connectorId = connectorId;
        this.metastore = metastore;
    }

    public void setup(Binder binder) {
        this.install((Module)new HiveMetastoreModule(this.connectorId, this.metastore));
        binder.bind(ExtendedHiveMetastore.class).to(CachingHiveMetastore.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreClientConfig.class);
        binder.bind(PartitionMutator.class).to(HivePartitionMutator.class).in(Scopes.SINGLETON);
        binder.bind(MetastoreCacheStats.class).to(HiveMetastoreCacheStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(MetastoreCacheStats.class).as(ObjectNames.generatedNameOf(MetastoreCacheStats.class, (String)this.connectorId));
        binder.bind(IcebergMetadataFactory.class).to(IcebergHiveMetadataFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MetastoreConfig.class);
    }
}

