/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.iceberg.ColumnIdentity;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.iceberg.MetadataColumns;

public enum IcebergMetadataColumn {
    FILE_PATH(MetadataColumns.FILE_PATH.fieldId(), "$path", (Type)VarcharType.VARCHAR, ColumnIdentity.TypeCategory.PRIMITIVE),
    DATA_SEQUENCE_NUMBER(2147482646, "$data_sequence_number", (Type)BigintType.BIGINT, ColumnIdentity.TypeCategory.PRIMITIVE);

    private static final Set<Integer> COLUMN_IDS;
    private final int id;
    private final String columnName;
    private final Type type;
    private final ColumnIdentity.TypeCategory typeCategory;

    private IcebergMetadataColumn(int id, String columnName, Type type, ColumnIdentity.TypeCategory typeCategory) {
        this.id = id;
        this.columnName = columnName;
        this.type = type;
        this.typeCategory = typeCategory;
    }

    public int getId() {
        return this.id;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getType() {
        return this.type;
    }

    public ColumnIdentity.TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    public static boolean isMetadataColumnId(int id) {
        return COLUMN_IDS.contains(id);
    }

    static {
        COLUMN_IDS = (Set)Stream.of(IcebergMetadataColumn.values()).map(IcebergMetadataColumn::getId).collect(ImmutableSet.toImmutableSet());
    }
}

