/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.FileFormat;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableProperties;
import com.facebook.presto.iceberg.IcebergTableType;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.IcebergWritableTableHandle;
import com.facebook.presto.iceberg.PartitionFields;
import com.facebook.presto.iceberg.util.IcebergPrestoModelConverters;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchTableException;

public class IcebergNativeMetadata
extends IcebergAbstractMetadata {
    private static final Logger LOG = Logger.get(IcebergNativeMetadata.class);
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final String TABLE_COMMENT = "comment";
    private final IcebergResourceFactory resourceFactory;
    private final CatalogType catalogType;

    public IcebergNativeMetadata(IcebergResourceFactory resourceFactory, TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, JsonCodec<CommitTaskData> commitTaskCodec, CatalogType catalogType, NodeVersion nodeVersion) {
        super(typeManager, functionResolution, rowExpressionService, commitTaskCodec, nodeVersion);
        this.resourceFactory = Objects.requireNonNull(resourceFactory, "resourceFactory is null");
        this.catalogType = Objects.requireNonNull(catalogType, "catalogType is null");
    }

    @Override
    protected Table getRawIcebergTable(ConnectorSession session, SchemaTableName schemaTableName) {
        return IcebergUtil.getNativeIcebergTable(this.resourceFactory, session, schemaTableName);
    }

    @Override
    protected boolean tableExists(ConnectorSession session, SchemaTableName schemaTableName) {
        IcebergTableName name = IcebergTableName.from(schemaTableName.getTableName());
        try {
            this.getIcebergTable(session, new SchemaTableName(schemaTableName.getSchemaName(), name.getTableName()));
        }
        catch (NoSuchTableException e) {
            return false;
        }
        return true;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        SupportsNamespaces supportsNamespaces = this.resourceFactory.getNamespaces(session);
        return supportsNamespaces.listNamespaces().stream().map(IcebergPrestoModelConverters::toPrestoSchemaName).collect(Collectors.toList());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && INFORMATION_SCHEMA.equals(schemaName.get())) {
            return this.listSchemaNames(session).stream().map(schema -> new SchemaTableName(INFORMATION_SCHEMA, schema)).collect(Collectors.toList());
        }
        return this.resourceFactory.getCatalog(session).listTables(IcebergPrestoModelConverters.toIcebergNamespace(schemaName)).stream().map(IcebergPrestoModelConverters::toPrestoSchemaTableName).collect(Collectors.toList());
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        this.resourceFactory.getNamespaces(session).createNamespace(IcebergPrestoModelConverters.toIcebergNamespace(Optional.of(schemaName)), properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString())));
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        try {
            this.resourceFactory.getNamespaces(session).dropNamespace(IcebergPrestoModelConverters.toIcebergNamespace(Optional.of(schemaName)));
        }
        catch (NamespaceNotEmptyException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Iceberg %s catalog does not support rename namespace", this.catalogType.name()));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        String formatVersion;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Schema schema = IcebergNativeMetadata.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        FileFormat fileFormat = IcebergTableProperties.getFileFormat(tableMetadata.getProperties());
        propertiesBuilder.put((Object)"write.format.default", (Object)fileFormat.toString());
        if (tableMetadata.getComment().isPresent()) {
            propertiesBuilder.put((Object)TABLE_COMMENT, tableMetadata.getComment().get());
        }
        if ((formatVersion = IcebergTableProperties.getFormatVersion(tableMetadata.getProperties())) != null) {
            propertiesBuilder.put((Object)"format-version", (Object)formatVersion);
        }
        try {
            this.transaction = this.resourceFactory.getCatalog(session).newCreateTableTransaction(IcebergPrestoModelConverters.toIcebergTableIdentifier(schemaTableName), schema, partitionSpec, (Map)propertiesBuilder.build());
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        Table icebergTable = this.transaction.table();
        return new IcebergWritableTableHandle(schemaName, new IcebergTableName(tableName, IcebergTableType.DATA, Optional.empty(), Optional.empty()), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), icebergTable.spec(), this.typeManager), icebergTable.location(), fileFormat, icebergTable.properties());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        Verify.verify((icebergTableHandle.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can be dropped", (Object[])new Object[0]);
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(icebergTableHandle.getSchemaTableName());
        this.resourceFactory.getCatalog(session).dropTable(tableIdentifier);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        IcebergTableHandle icebergTableHandle = (IcebergTableHandle)tableHandle;
        Verify.verify((icebergTableHandle.getIcebergTableName().getTableType() == IcebergTableType.DATA ? 1 : 0) != 0, (String)"only the data table can be renamed", (Object[])new Object[0]);
        TableIdentifier from = IcebergPrestoModelConverters.toIcebergTableIdentifier(icebergTableHandle.getSchemaTableName());
        TableIdentifier to = IcebergPrestoModelConverters.toIcebergTableIdentifier(newTable);
        this.resourceFactory.getCatalog(session).renameTable(from, to);
    }

    @Override
    public void registerTable(ConnectorSession clientSession, SchemaTableName schemaTableName, Path metadataLocation) {
        this.resourceFactory.getCatalog(clientSession).registerTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(schemaTableName), metadataLocation.toString());
    }

    @Override
    public void unregisterTable(ConnectorSession clientSession, SchemaTableName schemaTableName) {
        this.resourceFactory.getCatalog(clientSession).dropTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(schemaTableName), false);
    }
}

