/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergMetadataFactory;
import com.facebook.presto.iceberg.IcebergNativeMetadata;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.RowExpressionService;
import java.util.Objects;
import javax.inject.Inject;

public class IcebergNativeMetadataFactory
implements IcebergMetadataFactory {
    final TypeManager typeManager;
    final JsonCodec<CommitTaskData> commitTaskCodec;
    final IcebergResourceFactory resourceFactory;
    final CatalogType catalogType;
    final StandardFunctionResolution functionResolution;
    final RowExpressionService rowExpressionService;
    final NodeVersion nodeVersion;

    @Inject
    public IcebergNativeMetadataFactory(IcebergConfig config, IcebergResourceFactory resourceFactory, TypeManager typeManager, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, JsonCodec<CommitTaskData> commitTaskCodec, NodeVersion nodeVersion) {
        this.resourceFactory = Objects.requireNonNull(resourceFactory, "resourceFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        Objects.requireNonNull(config, "config is null");
        this.catalogType = config.getCatalogType();
    }

    @Override
    public ConnectorMetadata create() {
        return new IcebergNativeMetadata(this.resourceFactory, this.typeManager, this.functionResolution, this.rowExpressionService, this.commitTaskCodec, this.catalogType, this.nodeVersion);
    }
}

